/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelEnumeration;

public class ModelElementChooser
extends JDialog {
    private ModelEnumeration elements;
    private ModelElement[] selection;
    private Application parent;
    private boolean multiSelection;
    private JList elementList;
    private DefaultListModel elementModel;
    private int state;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = -1;

    public ModelElementChooser(Application application, String string, boolean bl, ModelEnumeration modelEnumeration, boolean bl2) {
        super(application, string, bl);
        this.elements = modelEnumeration;
        this.parent = application;
        this.multiSelection = bl2;
        this.createUI();
    }

    private void createUI() {
        this.getContentPane().add(this.createContentPanel());
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(this.parent);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ModelElementChooser.this.cancelAction();
            }
        });
        this.pack();
    }

    private JPanel createContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(20, 20));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)this.createListPanel(), "Center");
        jPanel.add((Component)this.createButtonPanel(), "South");
        return jPanel;
    }

    private JPanel createListPanel() {
        Object object;
        this.elementModel = new DefaultListModel();
        while (this.elements.hasMoreElements()) {
            this.elementModel.addElement(this.elements.nextElement());
        }
        this.elementList = new JList(this.elementModel);
        if (this.multiSelection) {
            this.elementList.setSelectionMode(2);
        } else {
            this.elementList.setSelectionMode(0);
            object = new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        ModelElementChooser.this.okAction();
                    }
                }
            };
            this.elementList.addMouseListener((MouseListener)object);
        }
        this.elementList.setCellRenderer(new ElementListCellRenderer());
        object = new JScrollPane();
        ((JComponent)object).setPreferredSize(new Dimension(400, 350));
        ((JComponent)object).setMaximumSize(new Dimension(400, 350));
        ((JComponent)object).setMinimumSize(new Dimension(400, 350));
        ((JScrollPane)object).setViewportView(this.elementList);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)object, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 30, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
        JButton jButton = new JButton(Resource.getString("MECHOOSER_CANCEL"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModelElementChooser.this.cancelAction();
            }
        });
        jButton.setPreferredSize(new Dimension(120, 25));
        jButton.setPreferredSize(new Dimension(120, 25));
        jButton.setPreferredSize(new Dimension(120, 25));
        JButton jButton2 = new JButton(Resource.getString("MECHOOSER_OK"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ModelElementChooser.this.okAction();
            }
        });
        jButton2.setPreferredSize(new Dimension(120, 25));
        jButton2.setPreferredSize(new Dimension(120, 25));
        jButton2.setPreferredSize(new Dimension(120, 25));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    protected void okAction() {
        Object[] objectArray = this.elementList.getSelectedValues();
        if (objectArray.length > 0) {
            this.selection = new ModelElement[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.selection[i] = (ModelElement)objectArray[i];
            }
        } else {
            return;
        }
        this.state = 0;
        this.dispose();
    }

    private void cancelAction() {
        this.selection = null;
        this.state = -1;
        this.dispose();
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public int showDialog() {
        this.show();
        return this.state;
    }

    public ModelElement[] getSelection() {
        return this.selection;
    }

    class ElementListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        ElementListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null) {
                String string = ((ModelElement)object).getFullName();
                this.setText(string);
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

