/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.print;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import org.musoft.limo.print.PrinterSource;

public class PrinterTask
implements Printable {
    private PrinterSource[] printables;
    private int currentPrintable = -1;
    private int startIndex;
    private int currentPage;
    private Rectangle figures;
    private int pageWidth;
    private int pageHeight;
    private int offsetX;
    private int offsetY;
    private double factor;
    private boolean fitToPage;
    private int rows = 0;
    private int columns = 0;
    private String title;

    public PrinterTask(PrinterSource[] printerSourceArray, double d, boolean bl) {
        this.printables = printerSourceArray;
        this.fitToPage = bl;
        this.factor = d;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        int n2 = fontMetrics.getHeight();
        d2 += (double)n2;
        d4 -= (double)n2;
        while (this.currentPage <= n) {
            if (this.currentPage - this.startIndex >= this.rows * this.columns) {
                this.figures = null;
                ++this.currentPrintable;
                if (this.currentPrintable == this.printables.length) {
                    return 1;
                }
            }
            if (this.figures == null) {
                this.startIndex = this.currentPage;
                this.figures = this.printables[this.currentPrintable].getPrintBounds();
                if (this.figures.width == 0) {
                    this.figures.width = 100;
                }
                if (this.figures.height == 0) {
                    this.figures.height = 100;
                }
                if (this.fitToPage) {
                    double d5 = Math.min(d3 / (double)this.figures.width, d4 / (double)this.figures.height);
                    this.factor = Math.min(this.factor, d5);
                }
                this.pageWidth = (int)(d3 / this.factor);
                this.pageHeight = (int)(d4 / this.factor);
                if (this.fitToPage) {
                    this.rows = 1;
                    this.columns = 1;
                } else {
                    this.rows = (this.figures.height + this.pageHeight - 1) / this.pageHeight;
                    this.columns = (this.figures.width + this.pageWidth - 1) / this.pageWidth;
                }
                this.offsetY = (this.rows * this.pageHeight - this.figures.height) / 2;
                this.offsetX = (this.columns * this.pageWidth - this.figures.width) / 2;
            }
            ++this.currentPage;
        }
        int n3 = (n - this.startIndex) / this.columns;
        int n4 = (n - this.startIndex) % this.columns;
        String string = this.printables[this.currentPrintable].getPrintTitle();
        String string2 = string + (this.fitToPage ? "" : " - Seite " + (n - this.startIndex + 1) + "/" + this.rows * this.columns);
        int n5 = fontMetrics.stringWidth(string2);
        graphics2D.drawString(string2, (int)(d + (d3 - (double)n5) / 2.0), (int)d2 - n2 + fontMetrics.getMaxAscent());
        graphics2D.translate(d, d2);
        graphics2D.scale(this.factor, this.factor);
        graphics2D.setColor(Color.lightGray);
        graphics2D.drawRect(0, 0, this.pageWidth, this.pageHeight);
        graphics2D.setClip(0, 0, this.pageWidth, this.pageHeight);
        graphics2D.translate(this.offsetX - this.figures.x - n4 * this.pageWidth, this.offsetY - this.figures.y - n3 * this.pageHeight);
        this.printables[this.currentPrintable].doPrintComponent(graphics2D);
        return 0;
    }
}

