/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.model;

import java.awt.Color;
import java.util.Vector;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelAttribute;
import org.musoft.limo.model.ModelComputedAttribute;
import org.musoft.limo.model.ModelException;
import org.musoft.limo.model.ModelListener;
import org.musoft.limo.model.ModelPrimitiveAttribute;
import org.musoft.limo.util.LogFile;

public abstract class ModelElement {
    private String name;
    private Vector attributes = new Vector();
    private Vector listeners = new Vector();

    public ModelElement(String string) {
        if (string != null) {
            this.setName(string);
        }
        this.addAttribute(new ModelPrimitiveAttribute(this, "Hyperlink", 3, ModelPrimitiveAttribute.TYPE_URL));
        this.addAttribute(new ModelPrimitiveAttribute(this, "Color", 3, ModelPrimitiveAttribute.TYPE_COLOR));
        this.addAttribute(new ModelPrimitiveAttribute(this, "notes", 0, ModelPrimitiveAttribute.TYPE_STRING));
        ((ModelPrimitiveAttribute)this.getAttribute("Color")).setValue(new Color(0xE0E0E0));
    }

    public ModelElement() {
        this(null);
    }

    public void destroy() {
        this.fireDestroy();
        this.listeners.removeAllElements();
        for (int i = this.getAttributeCount() - 1; i >= 0; --i) {
            ModelAttribute modelAttribute = this.getAttribute(i);
            if (modelAttribute instanceof ModelComputedAttribute) continue;
            this.getAttribute(i).clear();
        }
        this.changed();
    }

    protected void fireDestroy() {
        for (int i = this.getListenerCount() - 1; i >= 0; --i) {
            this.getListener(i).onDestroy(this);
        }
    }

    public void clear() {
        for (int i = this.getAttributeCount() - 1; i >= 0; --i) {
            ModelAttribute modelAttribute = this.getAttribute(i);
            if (modelAttribute instanceof ModelComputedAttribute) continue;
            this.getAttribute(i).clear();
        }
        this.changed();
    }

    public String getName() {
        return this.name;
    }

    public abstract String getFullName();

    public void setName(String string) {
        this.name = string;
        this.fireSetName();
        this.changed();
    }

    public ModelElement getChildOrConnection(String string) {
        return null;
    }

    protected void fireSetName() {
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onSetName(this);
        }
    }

    public abstract Model getModel();

    public Model getRootModel() {
        return this.getModel() == null ? null : this.getModel().getRootModel();
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public void addAttributeNew(ModelAttribute modelAttribute) {
        if (this.indexOfAttribute(modelAttribute.getName()) != -1) {
            throw new ModelException("Doppeltes Attribut \"" + modelAttribute.getName() + "\"");
        }
        this.attributes.addElement(modelAttribute);
    }

    public void addAttribute(ModelAttribute modelAttribute) {
    }

    public ModelAttribute getAttribute(int n) {
        return (ModelAttribute)this.attributes.elementAt(n);
    }

    public ModelAttribute getAttribute(String string) {
        int n = this.indexOfAttribute(string);
        if (n == -1) {
            throw new ModelException("Unbekanntes Attribut \"" + string + "\"");
        }
        return this.getAttribute(n);
    }

    public int indexOfAttribute(String string) {
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            String string2 = this.getAttribute(i).getName();
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    protected int getListenerCount() {
        return this.listeners.size();
    }

    protected ModelListener getListener(int n) {
        return (ModelListener)this.listeners.elementAt(n);
    }

    public int addListener(ModelListener modelListener) {
        if (this.listeners.contains(modelListener)) {
            LogFile.log("Warning: " + modelListener + " already listening to " + this, LogFile.WARNING);
        } else {
            this.listeners.addElement(modelListener);
        }
        return this.listeners.size();
    }

    public void removeListener(ModelListener modelListener) {
        this.listeners.removeElement(modelListener);
    }

    public void dump() {
        this.dump("");
    }

    private void dump(String string) {
        int n;
        String string2 = "." + this.getClass().getName();
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        System.out.println(string + "[" + this.name + ": " + string2 + "]");
        for (n = 0; n < this.getAttributeCount(); ++n) {
            System.out.println(string + this.getAttribute(n).toString());
        }
        if (this.listeners.size() != 0) {
            System.out.println();
            for (n = 0; n < this.listeners.size(); ++n) {
                System.out.println(string + "listener-" + n + "=" + this.listeners.elementAt(n));
            }
        }
    }

    private String toHex(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public String toString() {
        return this.getName() + ": " + this.getType();
    }

    public String getType() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string;
    }

    public boolean canSetName(String string) {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void changed() {
        Model model = this.getRootModel();
        if (model != null) {
            model.setDirty(true);
        }
    }

    public void primitiveAttributeChanged(ModelPrimitiveAttribute modelPrimitiveAttribute) {
    }

    public void associationEndChanged(ModelAssociationEnd modelAssociationEnd) {
    }
}

