/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.model;

import java.awt.Point;
import java.awt.Rectangle;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public abstract class ModelConnectionElement
extends ModelElement {
    private Model model;
    private ModelAssociationEnd start;
    private ModelAssociationEnd end;
    private ModelPrimitiveAttribute labelX;
    private ModelPrimitiveAttribute labelY;
    private Point[] points;
    private Point oldCenter;

    public ModelConnectionElement() {
        this(null, null);
    }

    public ModelConnectionElement(String string, Model model) {
        super(string);
        this.model = model;
        if (model != null) {
            model.addConnection(this);
        }
        this.start = new ModelAssociationEnd(this, "start", 1, false, this.getStartClass(), this.getStartName()){

            protected void removeAssociate(ModelElement modelElement, boolean bl) {
                super.removeAssociate(modelElement, bl);
                ModelConnectionElement.this.endDisconnected();
            }
        };
        this.end = new ModelAssociationEnd(this, "end", 1, false, this.getEndClass(), this.getEndName()){

            protected void removeAssociate(ModelElement modelElement, boolean bl) {
                super.removeAssociate(modelElement, bl);
                ModelConnectionElement.this.endDisconnected();
            }
        };
        this.labelX = new ModelPrimitiveAttribute(this, "labelX", 0, ModelPrimitiveAttribute.TYPE_INTEGER);
        this.labelY = new ModelPrimitiveAttribute(this, "labelY", 0, ModelPrimitiveAttribute.TYPE_INTEGER);
    }

    public void destroy() {
        super.destroy();
        if (this.model != null) {
            this.setModel(null);
        }
    }

    protected abstract Class getStartClass();

    protected abstract String getStartName();

    protected abstract Class getEndClass();

    protected abstract String getEndName();

    public void setModel(Model model) {
        if (this.model != null) {
            this.model.removeConnection(this);
        }
        this.model = model;
        if (this.model != null) {
            this.model.addConnection(this);
        }
    }

    public boolean canSetName(String string) {
        ModelElement modelElement;
        return this.model == null || (modelElement = this.model.getChildOrConnection(string)) == null || modelElement == this;
    }

    public String getFullName() {
        String string = this.model.getFullName();
        if (string == null) {
            return this.getName();
        }
        return string.equals("") ? this.getName() : string + "." + this.getName();
    }

    public Model getModel() {
        return this.model;
    }

    public void setStart(ModelFigureElement modelFigureElement) {
        this.start.clear();
        this.start.addAssociate(modelFigureElement);
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onSetConnectionStart(this);
        }
    }

    public void setEnd(ModelFigureElement modelFigureElement) {
        this.end.clear();
        this.end.addAssociate(modelFigureElement);
        for (int i = 0; i < this.getListenerCount(); ++i) {
            this.getListener(i).onSetConnectionEnd(this);
        }
    }

    public ModelFigureElement getStart() {
        return this.start.isEmpty() ? null : (ModelFigureElement)this.start.getAssociate(0);
    }

    public ModelFigureElement getEnd() {
        return this.end.isEmpty() ? null : (ModelFigureElement)this.end.getAssociate(0);
    }

    public boolean canConnect(ModelFigureElement modelFigureElement, ModelFigureElement modelFigureElement2) {
        return false;
    }

    private void endDisconnected() {
        if (this.getStart() == null && this.getEnd() == null) {
            this.destroy();
        }
    }

    public Point[] getPoints() {
        if (this.points == null) {
            return null;
        }
        Point[] pointArray = new Point[this.points.length];
        System.arraycopy(this.points, 0, pointArray, 0, this.points.length);
        return pointArray;
    }

    public void setPoints(Point[] pointArray) {
        this.points = pointArray;
        if (pointArray != null && pointArray.length != 0) {
            Rectangle rectangle = new Rectangle(pointArray[0]);
            for (int i = 1; i < pointArray.length; ++i) {
                rectangle.add(pointArray[i]);
            }
            Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            if (this.oldCenter == null) {
                this.oldCenter = new Point(0, 0);
            }
            this.labelX.setInteger(point.x - this.oldCenter.x + this.labelX.getInteger());
            this.labelY.setInteger(point.y - this.oldCenter.y + this.labelY.getInteger());
            this.oldCenter = point;
        }
    }
}

