/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.inspector;

import java.awt.BorderLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.ApplicationListener;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelElement;
import org.musoft.limo.model.ModelException;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelListener;
import org.musoft.limo.model.ModelPrimitiveAttribute;

public class NoticeEditor
extends JPanel
implements ApplicationListener,
ModelListener,
KeyListener {
    private Application parent;
    private ModelElement modelElement;
    private JTextArea textarea;
    private JScrollPane scroller;
    private boolean readOnly;

    public NoticeEditor(Application application) {
        super(new BorderLayout());
        this.parent = application;
        this.textarea = new JTextArea();
        this.textarea.addKeyListener(this);
        this.scroller = new JScrollPane();
        this.scroller.setViewportView(this.textarea);
        this.parent.addListener(this);
        this.readOnly = this.parent.getViewMode() != 0;
    }

    public void onSetName(ModelElement modelElement) {
    }

    public void onSetPosition(ModelFigureElement modelFigureElement, int n, int n2) {
    }

    public void onSetBounds(ModelFigureElement modelFigureElement) {
    }

    public void onSetParent(ModelFigureElement modelFigureElement) {
    }

    public void onCreateChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onAddChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onRemoveChild(ModelFigureElement modelFigureElement, ModelElement modelElement) {
    }

    public void onSetAttribute(ModelElement modelElement, String string, Object object) {
    }

    public void onSetAttribute(ModelElement modelElement, ModelPrimitiveAttribute modelPrimitiveAttribute) {
        if (modelPrimitiveAttribute == null) {
            return;
        }
        if (modelElement != this.modelElement || !modelPrimitiveAttribute.getName().equals("notes")) {
            return;
        }
        if (!modelPrimitiveAttribute.getString().equals(this.textarea.getText())) {
            this.textarea.setText(modelPrimitiveAttribute.getString());
        }
    }

    public void onAddAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
    }

    public void onRemoveAssociate(ModelElement modelElement, ModelAssociationEnd modelAssociationEnd, ModelElement modelElement2) {
    }

    public void onDestroy(ModelElement modelElement) {
    }

    public void onCreateConnection(Model model, ModelConnectionElement modelConnectionElement) {
    }

    public void onSetConnectionStart(ModelConnectionElement modelConnectionElement) {
    }

    public void onSetConnectionEnd(ModelConnectionElement modelConnectionElement) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        String string;
        if (this.modelElement == null) {
            return;
        }
        String string2 = ((JTextArea)keyEvent.getSource()).getText();
        if (!string2.equals(string = ((ModelPrimitiveAttribute)this.modelElement.getAttribute("notes")).getString())) {
            ((ModelPrimitiveAttribute)this.modelElement.getAttribute("notes")).setString(string2);
        }
    }

    public void onModelCreated(Application application, Model model) {
        this.add(this.scroller);
        this.onModelSelectionChanged(application, model, new ModelElement[0]);
    }

    public void onModelDestroying(Application application, Model model) {
        this.remove(this.scroller);
    }

    public void onModelLoaded(Application application, Model model) {
        this.add(this.scroller);
        this.onModelSelectionChanged(application, model, new ModelElement[0]);
    }

    public void onModelSaved(Application application, Model model) {
    }

    public void onModelSelectionChanged(Application application, Model model, ModelElement[] modelElementArray) {
        if (application != this.parent) {
            return;
        }
        if (this.modelElement != null) {
            this.modelElement.removeListener(this);
        }
        if (modelElementArray.length == 1 && this.modelElement != modelElementArray[0]) {
            this.modelElement = modelElementArray[0];
        } else if (modelElementArray.length != 1 || this.modelElement != modelElementArray[0]) {
            this.modelElement = model;
        }
        String string = "";
        if (this.modelElement != null) {
            ModelPrimitiveAttribute modelPrimitiveAttribute = null;
            this.modelElement.addListener(this);
            try {
                modelPrimitiveAttribute = (ModelPrimitiveAttribute)this.modelElement.getAttribute("notes");
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            if (modelPrimitiveAttribute != null) {
                string = modelPrimitiveAttribute.getString();
            }
        }
        this.textarea.setText(string);
        this.textarea.setEditable(this.modelElement != null && !this.readOnly);
        this.textarea.setEnabled(this.modelElement != null && !this.readOnly);
        this.textarea.setLineWrap(true);
        this.textarea.setWrapStyleWord(true);
        this.textarea.setAutoscrolls(true);
    }

    public void onStateChanged(Application application) {
    }

    public String toString() {
        return Resource.getString("COMP_NOTEPAD");
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        this.textarea.setEditable(this.modelElement != null && !this.readOnly);
        this.textarea.setEnabled(this.modelElement != null && !this.readOnly);
    }

    public void onSetDirty() {
    }

    public void onSetConnectionPoints(ModelConnectionElement modelConnectionElement) {
    }
}

