/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.drawing;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.jhotdraw.contrib.CustomSelectionTool;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.standard.DragTracker;
import org.musoft.limo.application.Application;
import org.musoft.limo.drawing.ModelConnection;
import org.musoft.limo.drawing.ModelDragTracker;
import org.musoft.limo.drawing.ModelDrawingView;
import org.musoft.limo.drawing.ModelFigure;
import org.musoft.limo.drawing.ModelHandleTracker;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelFigureElement;

public class ModelSelectionTool
extends CustomSelectionTool {
    private Application parent;

    public ModelSelectionTool(Application application) {
        super((DrawingEditor)application);
        this.parent = application;
    }

    protected void handleMouseDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        Figure figure = this.drawing().findFigure(mouseEvent.getX(), mouseEvent.getY());
        if (figure != null && figure instanceof ModelFigure) {
            ModelFigureElement modelFigureElement = ((ModelFigure)figure).getElement();
            if (modelFigureElement instanceof Model) {
                Application application = (Application)this.editor();
                application.newWindow((Model)modelFigureElement);
            }
            return;
        }
    }

    protected void handleMouseClick(MouseEvent mouseEvent, int n, int n2) {
    }

    protected Tool createDragTracker(Figure figure) {
        if (this.view() instanceof ModelDrawingView && ((ModelDrawingView)this.view()).isSelectOnly()) {
            return new DragTracker(this.editor(), figure){

                public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
                }
            };
        }
        if (figure instanceof ModelFigure) {
            if (((ModelFigure)figure).getMoveable()) {
                return new ModelDragTracker(this.editor(), (ModelFigure)figure);
            }
            return new DragTracker(this.editor(), figure){

                public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
                }
            };
        }
        return super.createDragTracker(figure);
    }

    protected Tool createHandleTracker(DrawingView drawingView, Handle handle) {
        if (this.view() instanceof ModelDrawingView && ((ModelDrawingView)this.view()).isSelectOnly()) {
            return new AbstractTool(this.editor()){};
        }
        if (handle.owner() instanceof ModelConnection) {
            return new ModelHandleTracker(this.editor(), handle);
        }
        return super.createHandleTracker(drawingView, handle);
    }

    public void keyDown(KeyEvent keyEvent, int n) {
        super.keyDown(keyEvent, n);
        if (keyEvent.getKeyChar() == '\u0001') {
            this.editor().view().clearSelection();
            this.editor().view().addToSelectionAll(this.drawing().figuresReverse());
        }
    }
}

