/*
 * Decompiled with CFR 0.152.
 */
package org.musoft.limo.drawing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingView;
import org.musoft.limo.application.Resource;
import org.musoft.limo.drawing.ModelDrawing;
import org.musoft.limo.drawing.ModelDrawingView;
import org.musoft.limo.model.Model;
import org.musoft.limo.util.DefaultPrintablePanel;

public class DrawingPanel
extends DefaultPrintablePanel {
    private DrawingView internalDrawingView;
    private JScrollPane scrollpane;
    private ModelDrawingView internalMDV;
    private JScrollBar observedHSB;
    private JScrollBar observedVSB;
    private static final int SPACE = 30;

    public DrawingPanel(DrawingView drawingView) {
        super(new GridLayout());
        this.scrollpane = new JScrollPane((JComponent)drawingView);
        this.scrollpane.setVerticalScrollBarPolicy(22);
        this.scrollpane.setHorizontalScrollBarPolicy(32);
        this.internalDrawingView = drawingView;
        this.add(this.scrollpane);
        this.observedVSB = this.scrollpane.getVerticalScrollBar();
        this.observedHSB = this.scrollpane.getHorizontalScrollBar();
        this.internalMDV = (ModelDrawingView)drawingView;
    }

    public DrawingView getDrawingView() {
        return this.internalDrawingView;
    }

    public void setDrawingView(DrawingView drawingView) {
        this.scrollpane.setViewportView((JComponent)drawingView);
        this.internalDrawingView = drawingView;
    }

    public void setDrawing(Drawing drawing) {
        this.getDrawingView().setDrawing(drawing);
    }

    public Drawing getDrawing() {
        return this.getDrawingView().drawing();
    }

    public String getPrintTitle() {
        if (this.internalDrawingView.drawing() instanceof ModelDrawing) {
            Model model = ((ModelDrawing)this.internalDrawingView.drawing()).getModel();
            Model model2 = model.getRootModel();
            String string = model.getFullName();
            string = model2.getName() + (string.length() != 0 ? "." : "") + string;
            return string;
        }
        return Resource.getString("DRAWING_PREFIX");
    }

    public void doPrintComponent(Graphics2D graphics2D) {
        this.internalDrawingView.drawing().draw((Graphics)graphics2D);
    }

    public Rectangle getPrintBounds() {
        return ((ModelDrawingView)this.internalDrawingView).getDrawingBounds();
    }

    public JScrollPane getScrollpane() {
        return this.scrollpane;
    }
}

