/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.schemamatching;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;

/**
 * Objects of this class are result matrices of 
 * schema matchers that implement the interface
 * <code>MmSchemaMatcher</code>.
 * 
 * @author Timm Euler
 * @version $Id: MatchingResult.java,v 1.3 2006/04/11 14:10:17 euler Exp $
 */
public class MatchingResult {
	
	private BaseAttribute ba1, ba2;
	private double similarity;
	
	/**
	 * @return Returns the BaseAttribute of the first schema.
	 */
	public BaseAttribute getBaOfFirstSchema() {
		return ba1;
	}
	
	/**
	 * @param ba The BaseAttribute to set.
	 */
	public void setBaOfFirstSchema(BaseAttribute ba) throws SchemaMatchException {
		try {
			if (this.ba2 != null && ba.getConcept().equals(this.ba2.getConcept())) {
				throw new SchemaMatchException("Cannot store matching similarity for two BaseAttributes of the same Concept!");
			}
		}
		catch (M4Exception m4e) {
			throw new SchemaMatchException("MatchingResult: M4 exception caught: " + m4e.getMessage());			
		}
		this.ba1 = ba;
	}
	/**
	 * @return Returns the BaseAttribute of the second schema.
	 */
	public BaseAttribute getBaOfSecondSchema() {
		return ba2;
	}
	/**
	 * @param ba The BaseAttribute to set.
	 */
	public void setBaOfSecondSchema(BaseAttribute ba) throws SchemaMatchException {
		try {
			if (this.ba1 != null && ba.getConcept().equals(this.ba1.getConcept())) {
				throw new SchemaMatchException("Cannot store matching similarity for two BaseAttributes of the same Concept!");
			}
		}
		catch (M4Exception m4e) {
			throw new SchemaMatchException("MatchingResult: M4 exception caught: " + m4e.getMessage());			
		}
		this.ba2 = ba;
	}
	/**
	 * @return Returns the similarity.
	 */
	public double getSimilarity() {
		return similarity;
	}
	
	/**
	 * @param similarity The similarity to set.
	 */
	public void setSimilarity(double similarity) {
		this.similarity = similarity;
	}
}
/*
 * $Log: MatchingResult.java,v $
 * Revision 1.3  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */

