/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator.uep;

import java.util.StringTokenizer;
import java.util.HashMap;

import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;


/**
 * <p>M4 Compiler</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University Dortmund</p>
 *
 * @author Felix Koschin
 * @version $Id: UserDefinedGroupingWithDefaultValue.java,v 1.6 2006/04/11 14:10:18 euler Exp $
 */
public class UserDefinedGroupingWithDefaultValue extends Grouping
{
	/* Parameters */
	public Value getDefault() throws M4CompilerError
	{
		return (Value) this.getSingleParameter("Default", this.getCurrentLoopNumber());
	}

	public Value[] getTheGroupings() throws M4CompilerError
	{
		return (Value[]) this.getParameter("TheGroupings", this.getCurrentLoopNumber());
	}

	public Value[] getLabels() throws M4CompilerError
	{
		return (Value[]) this.getParameter("Labels", this.getCurrentLoopNumber());
	}

	/* Basic methods */
	public String[] generateGroups(Column theTargetAttributeColumn) throws M4CompilerError
	{
		String[] myG;
		String s;
		Value[] myGroup;
		int i;

		defaultValue = true;
		myGroup = getTheGroupings();
		myG = new String[myGroup.length];
		HashMap ElList = new HashMap();

		doPrint(Print.OPERATOR,"UserDefinedGroupingWithDefaultValue:" );

		boolean useQuotes;
		try {
			useQuotes = this.useQuotes(theTargetAttributeColumn);
		}
		catch (M4Exception m4e) {
			throw new M4CompilerError(m4e.getMessage());
		}
		
		for (i = 0; i < myGroup.length; i++)
		{
			StringTokenizer T = new StringTokenizer(myGroup[i].getValue(), ",");
			s = null;
			while (T.hasMoreTokens())
			{
				if (s != null)
					s = s + ", ";
				else
					s = "";
				String x = T.nextToken();				
				if (ElList.get(x) == null)
				{
					if (useQuotes) {
						s = s + "'" + x + "'";
					}
					else {
						s = s + x;
					}
					ElList.put(x, new Integer(i));
				}
				else
				{
					if (((Integer)(ElList.get(x))).intValue() == i)
					{
						if (useQuotes) {
							s = s + "'" + x + "'";
						}
						else {
							s = s + x;
						}
						doPrint(Print.OPERATOR,"Warning: Value '" + x + "' ocurres more times in the " + (i + 1) + ". group specification!");
					}
					else
					{
						doPrint(Print.OPERATOR,"Error: Value '" + x + "' ocurres in more group specifications! (Groups: " + (((Integer)(ElList.get(x))).intValue() + 1) + ", " + (i + 1) + ")");
						return null;
					}					
				}
			}
			myG[i] = s;
		}

		return myG;
	}

	public String[] generateLabels(int num) throws M4CompilerError
	{
		Value[] tmpl = getLabels();
		Value[] l = new Value[tmpl.length + 1];
		
		String[] labels = new String[num + 1];
		int i;
		boolean gen = true;

		for (i = 0; i < tmpl.length; i++)
		{
			l[i] = tmpl[i];
		}
		l[tmpl.length] = getDefault();

		if (l.length != 0)
		{
			if (l.length > 0 && l.length != num)
				doPrint(Print.OPERATOR, "Incorrect number of given labels, labels generated automaticaly!");
			else
				gen = false;
		}

		for (i = 0; i < num; i++)
		{
			if (gen)
				labels[i] = "_" + (i + 1);
			else
				labels[i] = l[i].getValue();
		}
		return labels;
	}
}
/*
 * $Log: UserDefinedGroupingWithDefaultValue.java,v $
 * Revision 1.6  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.5  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.4  2006/03/30 16:07:14  scholz
 * fixed author tags for release
 *
 * Revision 1.3  2006/03/23 11:13:45  euler
 * Improved exception handling.
 *
 * Revision 1.2  2006/03/06 08:37:34  euler
 * *** empty log message ***
 *
 * Revision 1.1  2006/01/03 09:54:35  hakenjos
 * Initial version!
 *
 */
