/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator.uep;

import java.util.Collection;
import java.util.Vector;

import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.exception.M4CompilerError;

/**
 * <p>M4 Compiler</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University Dortmund</p>
 *
 * @author Felix Koschin
 * @version $Id: UserDefinedFeatureSelection.java,v 1.6 2006/04/11 14:10:18 euler Exp $
 */
public class UserDefinedFeatureSelection extends edu.udo.cs.miningmart.operator.FeatureSelection {

	public Feature[] getTheSelectedAttributes() throws M4CompilerError
	{
		return (Feature[]) this.getParameter("TheSelectedAttributes");
	}
	
	public Feature[] getTheAttributes() throws M4CompilerError
	{
		return getTheSelectedAttributes();
	}

	protected Collection computeListOfAttributes(Feature[] theSuperset) throws M4CompilerError{
		// return theSuperset as a Collection:
		Vector v = new Vector();
		for (int i = 0; i < theSuperset.length; i++)
		{   v.add(theSuperset[i]);   }
		v.trimToSize();
		return v;
	}
	
	/**
	 * @see edu.udo.cs.miningmart.operator.FeatureSelection#mustCopyFeature(String)
	 */
    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError 
    {						
		if (this.mySelectedFeatures == null)
		{	this.mySelectedFeatures = this.computeListOfAttributes(this.getTheAttributes());  }
		
		// Only copy the feature if it is one of the selected ones
		if (this.occursIn(nameOfFeature, this.mySelectedFeatures))
		{
			return true;  
		}		
	
		return false;
    }

}
/*
 * $Log: UserDefinedFeatureSelection.java,v $
 * Revision 1.6  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.5  2006/04/06 16:31:18  euler
 * Prepended license remark.
 *
 * Revision 1.4  2006/03/30 16:07:14  scholz
 * fixed author tags for release
 *
 * Revision 1.3  2006/03/23 11:13:46  euler
 * Improved exception handling.
 *
 * Revision 1.2  2006/01/05 10:27:38  hakenjos
 * Removed Javadoc Warnings!
 *
 * Revision 1.1  2006/01/03 09:54:35  hakenjos
 * Initial version!
 *
 */
