/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator.uep;

import java.util.ArrayList;
import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * <p>M4 Compiler</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University Dortmund</p>
 *
 * @author Felix Koschin
 * @version $Id: SimpleForwardFeatureSelectionGivenNoOfAttributes.java,v 1.5 2006/04/11 14:10:18 euler Exp $
 */
public class SimpleForwardFeatureSelectionGivenNoOfAttributes extends UepFeatureSelection
{

	public Collection computeListOfAttributes(Feature[] theSuperset) throws M4CompilerError
	{
		doPrint(Print.OPERATOR, "SimpleForwardFeatureSelectionGivenNoOfAttributes:");
		
		Column theClassAttribute;
		try {
			theClassAttribute = getTheClassAttribute().getCurrentColumn();
		}
		catch (M4Exception m4e)
		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  }
		
		ClassAttrEl = this.getM4Db().getDistinctElementsWithoutNull(theClassAttribute);
		
//*remove*/	myTable t = new myTable(this.getM4Db().getFrquencyTable(getTheClassAttribute().getCurrentColumn(), theSuperset, ClassAttrEl));
//*remove*/	t.print();

		ArrayList remaining = new ArrayList(theSuperset.length);
		for (int i = 0; i < theSuperset.length; i++)
		{
			remaining.add(theSuperset[i]);
		}
		long noOfAttr = Long.parseLong(getNoOfAttributes().getValue());
		ArrayList selected = new ArrayList((int)noOfAttr);
		
		while (selected.size() < noOfAttr)
		{			
			int maxID = selectTheBestAttr(selected, remaining).Index;
			selected.add(remaining.get(maxID));
			remaining.remove(maxID);
		}		
		
		/*
		Feature[] retF = new Feature[selected.size()];
		doPrint(Print.OPERATOR, "Selected attributes:");
		for (int i = 0; i < selected.size(); i++)
		{
			retF[i] = (Feature)selected.get(i);
			doPrint(Print.OPERATOR, retF[i].getName());
		}
		*/
		return selected;
	}	
}
/*
 * $Log: SimpleForwardFeatureSelectionGivenNoOfAttributes.java,v $
 * Revision 1.5  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/30 16:07:14  scholz
 * fixed author tags for release
 *
 * Revision 1.2  2006/03/23 11:13:46  euler
 * Improved exception handling.
 *
 * Revision 1.1  2006/01/03 09:54:35  hakenjos
 * Initial version!
 *
 */
