/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator.uep;

import java.util.StringTokenizer;
import java.util.TreeMap;

import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.exception.M4CompilerError;

/**
 * <p>M4 Compiler</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University Dortmund</p>
 *
 * @author Felix Koschin
 * @version $Id: GroupingGivenNoOfGroups.java,v 1.6 2006/04/11 14:10:18 euler Exp $
 */
public class GroupingGivenNoOfGroups extends Grouping
{
	/* Parameters */
	public Value getNoOfGroups() throws M4CompilerError
	{
		return (Value) this.getSingleParameter("NoOfGroups", this.getCurrentLoopNumber());
	}

	public Value[] getLabels() throws M4CompilerError
	{
		return (Value[]) this.getParameter("Labels", this.getCurrentLoopNumber());
	}

	/* Basic methods */
	public String[] generateLabels(int num) throws M4CompilerError
	{
		Value[] l = getLabels();
		String[] labels = new String[num];
		int i;
		boolean gen = true;

		if (l.length != 0)
		{
			if (l.length > 0 && l.length != num)
				doPrint(Print.OPERATOR, "Incorrect number of given labels, labels generated automaticaly!");
			else
				gen = false;
		}

		for (i = 0; i < num; i++)
		{
			if (gen)
				labels[i] = "_" + (i + 1);
			else
				labels[i] = l[i].getValue();
		}
		return labels;
	}

	public String[] generateGroups(Column theTargetAttributeColumn) throws M4CompilerError
	{
		String[] myG;
		String s;
		MyData x;
		TreeMap T = new TreeMap();
		int i;
		long c, sum;
		long NoOfGroups;

		/* SELECT TA, Count(TA) FROM ... */
		String[] elements = this.getM4Db().getCountOfElements(theTargetAttributeColumn);

		doPrint(Print.OPERATOR,"GroupingGivenNoOfGroups:");

		/* Parse string returned from getCountOfElements ("count,value")*/
		sum = 0;
		for(i = 0; i < elements.length; i++)
		{
			StringTokenizer st = new StringTokenizer(elements[i], ",");
			c = Long.parseLong(st.nextToken());
			x = new MyData("'" + st.nextToken() + "'", c, 0);
			T.put(x, new Integer(0));
			sum = sum + c;
		}

		NoOfGroups = Long.parseLong(getNoOfGroups().getValue());

		i = 0;
		while (T.size() > NoOfGroups)
		{
			x = (MyData)T.firstKey();
			s = x.name;
			c = x.cnt;
			T.remove(x);
			x = (MyData)T.firstKey();
			T.remove(x);
			x = new MyData(s + ", " + x.name, c + x.cnt, ++i);
			T.put(x, null);
		}

		myG = new String[T.size()];

		i = 0;
		while (T.size() > 0)
		{
			x = (MyData)T.firstKey();
			doPrint(Print.OPERATOR, "Group " + (i + 1) + " has " + x.cnt + " elements of this: " + x.name);
			myG[i++] = x.name;
			T.remove(x);
		}

		return myG;
	}

	/* Auxiliary classes */
	public class MyData implements Comparable
	{
		public String name;
		public long cnt;
		public long iter;

		public MyData(String Name, long Count, long Iter)
		{
			name = Name;
			cnt = Count;
			iter = Iter;
		}

		public int compareTo(Object Obj)
		{
			int x;
			if (cnt == (((MyData)Obj)).cnt)
				if (iter == ((MyData)Obj).iter)
					x = name.compareTo(((MyData)Obj).name);
				else
					if (iter > (((MyData)Obj).iter))
						x = -1;
					else
						x = 1;
			else
				if (cnt > (((MyData)Obj)).cnt)
					x = 1;
				else
					x = -1;
			return x;
		}

		public boolean equals(Object Obj){
			return ((cnt == ((MyData)Obj).cnt) && (iter == (((MyData)Obj).iter)) && (name.equals(((MyData)Obj).name)));
		}
	}
}
/*
 * $Log: GroupingGivenNoOfGroups.java,v $
 * Revision 1.6  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.5  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.4  2006/03/30 16:07:14  scholz
 * fixed author tags for release
 *
 * Revision 1.3  2006/03/23 11:13:46  euler
 * Improved exception handling.
 *
 * Revision 1.2  2006/01/06 16:27:57  euler
 * Bugfixes
 *
 * Revision 1.1  2006/01/03 09:54:35  hakenjos
 * Initial version!
 *
 */
