/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.RelationalDatatypes;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.FeatureConstruction;

/**
 * <p>M4 Compiler</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University Dortmund</p>
 *
 * @author Felix Koschin
 * @version $Id: Grouping.java,v 1.6 2006/04/11 14:10:18 euler Exp $
 */
public abstract class Grouping extends FeatureConstruction
{
	boolean defaultValue = false;

	//~ Constructors ..........................................................

	public Grouping()
	{
		super();
	}

	//~ Methods ...............................................................

	/**
	* @returns An SQL definition for a scaled column.
	*/

	abstract String[] generateGroups(Column theTargetAttributeColumn) throws M4CompilerError;

	private String createUniqueLabel(String[] labels, int currentLabel)
	{
		String s;
		int i;
		boolean unique;

		s = "" + currentLabel;
		unique = false;
		while (!unique){
			s = "_" + s;
			unique = true;
			for (i = 0; labels.length < i ;i++){
				if (s.equalsIgnoreCase(labels[i])){
					unique = false;
					break;
				}
			}
		}
		return s;
	}

	public String[] generateLabels(int num) throws M4CompilerError
	{
		String[] labels = new String[num];
		int i;

		for (i = 0; i < num; i++)
			labels[i] = createUniqueLabel(labels, i + 1);
		return labels;
	}

	public String generateSQL(Column theTargetAttributeColumn) throws M4CompilerError
	{
		String[] myG;
		String[] myL;
		String sql = "CASE ";
		int i;

		if ((myG = generateGroups(theTargetAttributeColumn)) == null)
		{
			return null;
		}
		if (defaultValue)
			myL = generateLabels(myG.length + 1);
		else
			myL = generateLabels(myG.length);

//		sql = CASE WHEN Attr IN ('A', 'B', 'C') THEN Label1 WHEN Attr IN ('D', 'E') THEN Label2 ... END
		for (i = 0; i < myG.length; i++)
		{
			sql = sql + "WHEN " + theTargetAttributeColumn.getSQLPlusLocation() + " IN (" + myG[i] + ") THEN '" + myL[i] + "' ";
		}

		if (defaultValue)
			sql = sql + "ELSE ('" + myL[myG.length] + "') END";
		else
			sql = sql + "ELSE " + theTargetAttributeColumn.getSQLPlusLocation() + " END";

		doPrint(Print.OPERATOR,"String returned by grouping: " + sql);

		return "(" + sql + ")";
	}
	
	protected boolean useQuotes(Column targetAttribCol) throws M4Exception {
		try {
			if (targetAttribCol.getColumnDataTypeName().equals(RelationalDatatypes.RELATIONAL_DATATYPE_STRING)) {
				return true;
			}
		}
		catch (DbConnectionClosed c) {	
			throw new M4Exception(c.getMessage());
		}
		return false;
	}
}
/*
 * $Log: Grouping.java,v $
 * Revision 1.6  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.5  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.4  2006/03/30 16:07:14  scholz
 * fixed author tags for release
 *
 * Revision 1.3  2006/03/23 11:13:46  euler
 * Improved exception handling.
 *
 * Revision 1.2  2006/03/06 08:37:34  euler
 * *** empty log message ***
 *
 * Revision 1.1  2006/01/03 09:54:35  hakenjos
 * Initial version!
 *
 */
