/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * <p>M4 Compiler</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: University Dortmund</p>
 *
 * @author Felix Koschin
 * @version $Id: EquidistantDiscretizationGivenNoOfIntervals.java,v 1.5 2006/04/11 14:10:18 euler Exp $
 */
public class EquidistantDiscretizationGivenNoOfIntervals extends Discretization

{
	/* Parameters */
	public Value getNoOfIntervals() throws M4CompilerError
	{
		return (Value) this.getSingleParameter("NoOfIntervals", this.getCurrentLoopNumber());
	}

	public Value getClosedTo() throws M4CompilerError
	{
		return (Value) this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
	}

	public Value[] getLabels() throws M4CompilerError
	{
		return (Value[]) this.getParameter("Labels", this.getCurrentLoopNumber());
	}

	/* Basic methods */
	public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError
	{
		String Max, Min;
		double max, min;
		double width;
		int numOfIntervals;
		int i;
		double[] cutPoints;

		doPrint(Print.OPERATOR,"EquidistantDiscretizationGivenNoOfIntervals:" );

		try {
			Min = theTargetAttributeColumn.readOrComputeMinimum();
			min = Double.parseDouble(Min);
			
			numOfIntervals = Integer.parseInt(getNoOfIntervals().getValue());

			Max = theTargetAttributeColumn.readOrComputeMaximum();
			max = Double.parseDouble(Max);
			width = (max - min)/numOfIntervals;

			cutPoints = new double[numOfIntervals - 1];

			for (i = 1; i < numOfIntervals; i++)
				cutPoints[i - 1] = min + i * width;

			return cutPoints;
		}
	    catch (M4Exception e) {
	    	throw new M4CompilerError(e.getMessage());
	    }
	}

	public String[] generateLabels(int num) throws M4CompilerError
	{
		Value[] l = getLabels();
		String[] labels = new String[num];
		int i;
		boolean gen = true;

		if (l.length != 0)
		{
			if (l.length > 0 && l.length != num)
				doPrint(Print.OPERATOR, "Incorrect number of given labels, labels generated automaticaly!");
			else
				gen = false;
		}

		for (i = 0; i < num; i++)
		{
			if (gen)
				labels[i] = "_" + (i + 1);
			else
				labels[i] = l[i].getValue();
		}
		return labels;
	}
}
/*
 * $Log: EquidistantDiscretizationGivenNoOfIntervals.java,v $
 * Revision 1.5  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/30 16:07:13  scholz
 * fixed author tags for release
 *
 * Revision 1.2  2006/03/23 11:13:46  euler
 * Improved exception handling.
 *
 * Revision 1.1  2006/01/03 09:54:35  hakenjos
 * Initial version!
 *
 */
