/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;

/**
 * @author Martin Scholz
 * @version $Id: TupleWiseModelApplier.java,v 1.3 2006/04/11 14:10:12 euler Exp $
 */
abstract public class TupleWiseModelApplier extends ModelApplier {

	/** Predicts the values applying the specified models. */
	protected void predict() throws M4Exception, M4CompilerError {
		Long fromRowNum = null;
		Long toRowNum = null;
		String sql = getDatabaseQueryForRows(fromRowNum, toRowNum);
		
		final Vector keyNameCol = this.getKeyColumnNames();
		final String keyNames = stringCollectionToCommaSeparatedString(keyNameCol);
		
		final Vector predByNameCol = this.getPredictionColumnNames();
		// final String predByNames = stringCollectionToCommaSeparatedString(predByNameCol);

		final Vector predTargetsCol = new Vector();
		{
			// StringBuffer predictBuf = new StringBuffer();
			for (int loop=0; loop<this.getNumberOfLoops(); loop++) {
				BaseAttribute curPredBa = this.getPredictedAttribute(loop);
				String predColName = curPredBa.getName();
				predTargetsCol.add(predColName);
				this.createPredictedAttributeInDb(loop);
			}
		}
		final String predTargets = stringCollectionToCommaSeparatedString(predTargetsCol);

		final String targetTable = this.getTargetTableName();
		String sqlPre = "INSERT INTO " + targetTable + " ( " + keyNames + ", " + predTargets + " ) VALUES ( ";
		String sqlPost = " )";
		
		try {
			ResultSet rs = this.executeBusinessSqlRead(sql);
			while (rs.next()) {
				String[] targetTableValues = new String[keyNameCol.size() + predTargetsCol.size()];
				for (int i=0; i<keyNameCol.size(); i++) {
					targetTableValues[i] = rs.getString((String) keyNameCol.get(i));
				}
				
				String[] predInfo = new String[predByNameCol.size()];
				for (int i=0; i<predByNameCol.size(); i++) {
					predInfo[i] = rs.getString((String) predByNameCol.get(i));
				}

				for (int i=0; i<predTargetsCol.size(); i++) {
					targetTableValues[i + keyNameCol.size()] = this.getPredictionFor(predInfo);
				}			

				this.insertIntoDb(targetTableValues, sqlPre, sqlPost);
			}
		}
		catch (SQLException e) {
			throw new M4CompilerError(e.getMessage());
		}		
	}

	protected void insertIntoDb(String[] valueArray, String sqlPrefix, String sqlSuffix) 
		throws M4CompilerError, SQLException
	{
		StringBuffer buf = new StringBuffer();
		for (int i=0; i<valueArray.length; i++) {
			buf.append(valueArray[i] + ", ");		
		}
		String sql = sqlPrefix + buf.substring(0, buf.length() - 2) + sqlSuffix;
		this.executeBusinessSqlWrite(sql);
	}

	abstract protected String getPredictionFor(String[] predictBy);

}
/*
 * Historie
 * --------
 *
 * $Log: TupleWiseModelApplier.java,v $
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:22  hakenjos
 * Initial version!
 *
 */
