/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.compiler.wrapper.DB_SVM_RG;
import edu.udo.cs.miningmart.compiler.wrapper.SVM_RG;
import edu.udo.cs.miningmart.compiler.wrapper.SVM_Wrapper;

/**
 * This operator uses mySVM to realize a Support Vector Machine for regression.
 * 
 * @see edu.udo.cs.miningmart.m4.core.operator.SVM_ForDataMining
 * 
 * @author Timm Euler
 * @version $Id: SupportVectorMachineForRegression.java,v 1.4 2006/04/11 14:10:11 euler Exp $
 */
public class SupportVectorMachineForRegression extends SVMforDataMining
{
	protected SVM_Wrapper constructWrapper(boolean useDB_SVM) throws M4CompilerError
	{
		SVM_Wrapper mysvm = null;
	    try
        {        
        	if (useDB_SVM)
        	{        		
        		BaseAttribute keyBA = this.getKey();
        		String key = null;
        		if (keyBA != null)
        		{  key = keyBA.getCurrentColumn().getName();  }
        		
        		long s = this.getSampleSize();
        		
        		if (s == -1)
        		{
	        		mysvm = new DB_SVM_RG( this.getM4Db(),
				    			   		   this.getM4Db().getCasePrintObject(),
				    			   		   this.getPrefixForDatabaseObjects(),
				    			   		   this.getDatabaseSchema(),
				    			   		   this.getStep().getId(),
			    				   		   key,
			    				   		   this.getLossFunctionPos(),
			    				   		   this.getLossFunctionNeg());
        		}
        		else
        		{
        			
	        		mysvm = new DB_SVM_RG( this.getM4Db(),
				    			   		   this.getM4Db().getCasePrintObject(),
				    			   		   this.getPrefixForDatabaseObjects(),
				    			   		   this.getDatabaseSchema(),
				    			   		   this.getStep().getId(),
			    				   		   key,
			    				   		   s,
			    				   		   this.getLossFunctionPos(),
			    				   		   this.getLossFunctionNeg());
        		}
        	}
        	else
        	{        		
		        long sample = this.getSampleSize();
		        if (sample == -1)
		        {   sample = SVM_Wrapper.DEFAULTSAMPLESIZE;   }
		        
	        	mysvm = new SVM_RG( this.getM4Db(),
			    			   		this.getM4Db().getCasePrintObject(),
			    			   		this.getPrefixForDatabaseObjects(),
			    			   		this.getDatabaseSchema(),
			    			   		this.getStep().getId(),
				   			   		sample,
			   				   	    this.getLossFunctionPos(),
			    				   	this.getLossFunctionNeg());
        	}
	    }
	    catch (Exception e)
        {   this.doPrint(e); 
        	throw new M4CompilerError("SupportVectorMachineForRegression: Error when constructing SVM wrapper!");   
        }
        return mysvm;
	}
}
/*
 * Historie
 * --------
 *
 * $Log: SupportVectorMachineForRegression.java,v $
 * Revision 1.4  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:13  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:21  hakenjos
 * Initial version!
 *
 */
