/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;

/**
 * Creates a view on the input table/view that contains 
 * no two equal tuples (rows).
 * 
 * @author Timm Euler
 * @version $Id: RemoveDuplicates.java,v 1.3 2006/04/11 14:10:11 euler Exp $
 */
public class RemoveDuplicates extends SingleCSOperator {

	private static final String INTERNAL_VIEW_NAME = "foo"; 
		
	/**
	 * @see edu.udo.cs.miningmart.m4.core.operator.SingleCSOperator#generateSQLDefinition(String)
	 */
    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
    	try {
    		String input = this.getInputConcept().getCurrentColumnSet().getSchemaPlusName();
	        String viewDef = "(select " + selectPart +
		                     " from " + 
							      "(select * from " + input +
								  " intersect select * from " + input +
								  ") " + INTERNAL_VIEW_NAME +
							 ")";	
	        return viewDef;
    	}
   		catch (M4Exception m4e)
   		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  } 
    } 

	/**
	 * The superclass method is overwritten in order to create
	 * a correct SELECT String that matches the internal FROM part. 
	 * 
	 * @param inputColumn the given input column
	 * @return a String for the SELECT part of a view definition
	 */
	protected String getStringForSelection(Column inputColumn) {
	    // contribute to view-creating string:
	    String nextAttrib = inputColumn.getSQLDefinition();
	    
	    if (! inputColumn.getName().equals(nextAttrib)) {
	    	// following line:
	       	// nextAttrib = "(" + inputColumn.getSQLPlusLocation() + ") AS " + inputColumn.getName();
	       	// was replaced because it leads to things like "schemaname.tablename.(virtualcolumndefinition)"
	       	//    which is not well-formed SQL
	       	nextAttrib = "(" + inputColumn.getSQLDefinition() + ") AS " + inputColumn.getName();
	    }
	    else {
		    // unlike the superclass method we do not use the notation
	    	// "inputCsName.columnName" but "foo.columnName" because "foo"
	    	// is used in the internal FROM part:
	    	nextAttrib = INTERNAL_VIEW_NAME + "." + nextAttrib;
	    }
	    return nextAttrib;
	}
    
    /**
     * @see edu.udo.cs.miningmart.m4.core.operator.ConceptOperator#getTypeOfNewColumnSet(int)
     */
    public String getTypeOfNewColumnSet()
    {  return Columnset.CS_TYPE_VIEW;  }

    /**
     * @see edu.udo.cs.miningmart.m4.core.operator.ConceptOperator#mustCopyFeature(String)
     */
    protected boolean mustCopyFeature(String nameOfFeature) {
        // This operator copies all BAs from input to output.
        return true;
    }    
}
/*
 * Historie
 * --------
 * 
 * $Log: RemoveDuplicates.java,v $
 * Revision 1.3  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/02/01 14:57:12  euler
 * New operator RemoveDuplicates
 *
 */
