/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.exception.M4CompilerError;

/**
 * The class <i>Mapping</i> is abstract class
 * for the operators of type Mapping
 *
 * @see MappingWithDefaultValue
 * @see PartialMapping
 * 
 * @author Cezary Chudzian
 * @version $Id: Mapping.java,v 1.4 2006/04/11 14:10:11 euler Exp $
 */
public abstract class Mapping extends FeatureConstruction {

	/** Implemented in subclasses
	 * @return value to map to if mapping is not specified
	 * @change July, 18th, 2002 method created
	 */
	public abstract String getDefault(Column theTargetAttributeColumn) throws M4CompilerError;
	
	/** Generates a sql-function to describe a new column.
	 * This method generates a sql-function to describe a new
	 * column.
	 * @return the SQL-function call
	 * @change July, 18th, 2002 method created
	 */
	public String generateSQL(Column theTargetAttributeColumn)
		throws M4CompilerError {
		StringBuffer sBuff = new StringBuffer();
		sBuff.append(
			"decode(" + theTargetAttributeColumn.getSQLPlusLocation() + ",");
		for (int i = 0;
			i < this.getTheMappings(getCurrentLoopNumber()).length;
			i++)
			sBuff.append(
				this.getTheMappings(this.getCurrentLoopNumber())[i].getValue()
					+ ",");
		//sBuff.append(defMapping[this.getCurrentLoopNumber()].getValue() + ")");
		sBuff.append(getDefault(theTargetAttributeColumn) + ")");
		this.doPrint(Print.OPERATOR, "generatedSQL: " + sBuff.toString());
		return sBuff.toString();
	}

	/**
	 * Gets the theMappings.
	 * @param loopNr the loop number to get the Parameter for
	 * @return Returns a Value[]
	 */
	public Value[] getTheMappings(int loopNr) throws M4CompilerError {
		return (Value[]) this.getParameter("Mapping", loopNr);
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: Mapping.java,v $
 * Revision 1.4  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/23 11:13:44  euler
 * Improved exception handling.
 *
 * Revision 1.1  2006/01/03 09:54:22  hakenjos
 * Initial version!
 *
 */
