/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Feature;

/**
 * This operator chooses all Features that are present in TheOutputConcept.
 * 
 * @author Timm Euler
 * @version $Id: FeatureSelectionByAttributes.java,v 1.4 2006/04/11 14:10:11 euler Exp $
 */
public final class FeatureSelectionByAttributes extends FeatureSelection {

	/**
	 * @see edu.udo.cs.miningmart.m4.core.operator.FeatureSelection
	 */
    protected Collection computeListOfAttributes(Feature[] theSuperset) throws M4CompilerError
    {
    	// ignore theSuperset
    	try {
			return this.getOutputConcept().getFeatures();	
    	}
   		catch (M4Exception m4e)
   		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  }    		
    }
    
    /**
     * Overrides the method from the superclass because this operator
     * does not need the parameter "TheAttributes".
     * 
     * @return an array of features
     */
	protected Feature[] getTheAttributes() throws M4CompilerError
	{
		try {
			Collection featCol = this.getInputConcept().getFeatures();
			if (featCol != null) {
				return (Feature[]) featCol.toArray(new Feature[featCol.size()]);
			}
			else return new Feature[0];
		}
   		catch (M4Exception m4e)
   		{   throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());  }    		
	}
}
/*
 * Historie
 * --------
 *
 * $Log: FeatureSelectionByAttributes.java,v $
 * Revision 1.4  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:22  hakenjos
 * Initial version!
 *
 */

/*
 * Old Historie
 * ------------
 *
 * Revision 1.17  2002/11/08 15:11:56  euler
 * Added parameter "TheAttributes".
 *
 * Revision 1.16  2002/11/04 10:01:52  euler
 * New Javadoc comments.
 *
 * Revision 1.15  2002/10/21 16:17:21  scholz
 * javadoc comments: fixed some invalid tags
 *
 * Revision 1.14  2002/10/01 14:22:30  euler
 * New Feature Selection class.
 *
 * Revision 1.13  2002/08/05 10:35:47  euler
 * Restructured the operator hierarchy: introduction of SingleCSOperator
 * and MultipleCSOperator. Changed this class accordingly.
 *
 * Revision 1.12  2002/07/11 08:36:34  euler
 * Changed printing of messages.
 *
 * Revision 1.11  2002/06/13 16:04:56  euler
 * Changed matching of features of output and input concept.
 * This now uses the method Feature.correspondsTo().
 *
 * Revision 1.10  2002/06/12 13:59:02  euler
 * Added MultiRelationalFeatureConstruction.
 *
 * Revision 1.9  2002/06/05 06:56:26  euler
 * Commented the code.
 *
 * Revision 1.7  2002/05/31 15:11:59  euler
 * Changed link from column to BA to 1:n.
 *
 * Revision 1.6  2002/05/31 12:35:01  euler
 * *** empty log message ***
 *
 * Revision 1.5  2002/05/23 11:34:59  euler
 * A few tests worked, others still to be done.
 *
 * Revision 1.4  2002/05/15 10:36:42  euler
 * First version that compiles.
 *
 * Revision 1.3  2002/05/14 12:56:03  euler
 * First M4 extensions, does not yet compile
 *
 * Revision 1.2  2002/05/10 13:23:21  euler
 * First M4 extensions, does not yet compile
 *
 * Revision 1.1  2002/04/30 13:00:28  wiese
 * compileable version
 *
 * Revision 1.6  2002/04/19 15:23:12  wiese
 * Initialversion nach der uebergabe
 *
 */

