/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;

/**
 * @author Martin Scholz
 * @version $Id: DateToNumeric.java,v 1.5 2006/04/11 14:10:11 euler Exp $
 */
public class DateToNumeric extends FeatureConstruction {
	
	/**
	 * @see FeatureConstruction#generateSQL(Column)
	 */
	public String generateSQL(Column targetColumn) throws M4CompilerError {
		String format = this.getOutputFormat();
		String sql = targetColumn.getSQLDefinition();
		short myDbms = this.getM4Db().getBusinessDbms();
		String ret = this.getFormatMapping(format, myDbms);
		if (myDbms == DB.ORACLE) {
			ret = "TO_NUMBER(TO_CHAR(" +sql + ", '" + ret +"'))";
		}
		if (myDbms == DB.POSTGRES) {
			ret = "EXTRACT(" +ret + " FROM " + sql + ")";
		}
		return ret;
	}

	private static String[][] dateFormatsMapping = {
			 // third column is used for Postgres
		{"Year_YYYY",      "YYYY", "year"},
		{"Year_YY",          "YY", "year"}, // YY not supported by Postgres
		{"Month_of_Year",    "MM", "month"},
		{"Day_of_Month",     "DD", "day"},
		{"Hour_of_Day",    "HH24", "hour"},
		{"Minute_of_Hour",   "MI", "minute"},
		{"Second_of_Minute", "SS", "second"}
	};

	private String getFormatMapping(String format, short theDbms) 
	throws M4CompilerError {
		if (format != null) {
			for (int i=0; i<dateFormatsMapping.length; i++) {
				if (format.equalsIgnoreCase(dateFormatsMapping[i][0])) {
					if (theDbms == DB.ORACLE) {
						return dateFormatsMapping[i][1];
					}
					if (theDbms == DB.POSTGRES) {
						return dateFormatsMapping[i][2];
					}
				}
			}
		}
		
		throw new M4CompilerError(
			"Operator 'DateToNumeric': Unsupported entry found in mandatory parameter 'OutputFormat': "
			+ (format == null ? "<null>" : "'" + format + "'"));		
	}

	private String getOutputFormat() throws M4CompilerError {
		Value value = (Value) this.getSingleParameter("OutputFormat", this.getCurrentLoopNumber());
		if (value == null)
			return null;
		else return value.getValue();
	}

}
/*
 * Historie
 * --------
 *
 * $Log: DateToNumeric.java,v $
 * Revision 1.5  2006/04/11 14:10:11  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/23 11:13:45  euler
 * Improved exception handling.
 *
 * Revision 1.2  2006/03/06 08:37:34  euler
 * *** empty log message ***
 *
 * Revision 1.1  2006/01/03 09:54:22  hakenjos
 * Initial version!
 *
 */
