/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * This operator replaces missing values with the modal value of that column.
 * 
 * @author Timm Euler
 * @version $Id: AssignModalValue.java,v 1.5 2006/04/11 14:10:12 euler Exp $
 */
public class AssignModalValue extends MissingValues 
{    
    /** 
     * @see miningmart.operator.MissingValues#generateValueForOp(Column)
     */
    public String generateValueForOp(Column columnWithMissingValues)
    	throws M4CompilerError
    {    	
		String modal;
		try {
			modal = columnWithMissingValues.getModalValue();
		}
		catch (M4Exception e) {
			throw new M4CompilerError(e.getMessage());	
		}

		if (modal == null)
		{
			try
			{
				this.doPrint(
					Print.OPERATOR,
					"Computing modal value for TheTargetAttribute for AssignModalValue...");
				columnWithMissingValues.updateStatistics();
				modal = columnWithMissingValues.getModalValue();
			}
			catch (M4Exception m4e)
			{	throw new M4CompilerError("AssignStochasticValue: error when computing statistics for column with missing values: " +
				                          m4e.getMessage());
			}
		}
		
    	if (columnWithMissingValues.getColumnDataType() == 12)
    	{   return modal;  }
    	else
    	{   return DB.quote(modal);  }
    }
}
/*
 * Historie
 * --------
 *
 * $Log: AssignModalValue.java,v $
 * Revision 1.5  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/30 16:07:13  scholz
 * fixed author tags for release
 *
 * Revision 1.2  2006/01/12 20:35:18  scholz
 * bugfix statistics
 *
 * Revision 1.1  2006/01/03 09:54:22  hakenjos
 * Initial version!
 *
 */

/*
 * Old Historie
 * --------
 *
 * Revision 1.8  2002/11/18 15:09:58  euler
 * Respects String datatypes now.
 *
 * Revision 1.7  2002/10/21 16:17:20  scholz
 * javadoc comments: fixed some invalid tags
 *
 * Revision 1.6  2002/09/05 17:06:29  scholz
 * cleaned up some more operators (wrt. autoload), e.g.
 * Scaling and sub-classes and some MissingValues operators.
 *
 * Revision 1.5  2002/08/05 10:35:46  euler
 * Restructured the operator hierarchy: introduction of SingleCSOperator
 * and MultipleCSOperator. Changed this class accordingly.
 *
 * Revision 1.4  2002/06/03 12:02:36  euler
 * Restructured FeatureConstruction.
 *
 * Revision 1.3  2002/05/15 10:36:42  euler
 * First version that compiles.
 *
 * Revision 1.2  2002/05/14 14:05:49  bauschul
 * errors corrected, but not the errors converning the baseattributes
 *
 * Revision 1.1  2002/04/30 13:00:26  wiese
 * compileable version
 *
 * Revision 1.6  2002/04/19 15:23:12  wiese
 * Initialversion nach der uebergabe
 *
 */
