/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.utils;

import java.io.Serializable;

/** 
 * This class holds statistical information for one column, representing
 * the table colstatist2_t.
 * 
 * @author Timm Euler
 * @version $Id: ValueCount.java,v 1.3 2006/04/11 14:10:10 euler Exp $
 */
public class ValueCount implements Serializable {

   /* The value to be counted. For numeric attributes with more than
    * 1000 different values this field contains the mean of the
    * interval [min-max] */
  private String myValue;

  /* The counter of the number of records with this value / with
   * values in the interval*/
  private int myCount;

  /* This is the minimal values of the interval. Only filled for
   * numeric fields with more than 1000 different values.  In this
   * case statistics are computed on 1000 equal large intervals. */
  private double myMin;

  /* This is the maximal values of the interval. Only filled for
   * numeric fields with more than 1000 different values.  In this
   * case statistics are computed on 1000 equal large intervals. */
  private double myMax;


  /* Problem with doPrint(..) and method never used, so commented out ...
    public void print()
    {
        this.doPrint(Print.M4_OBJECT, myValue + " occurs " + myCount + " times");
    }
  */

	/**
	 * Setter method.
	 * 
	 * @param v the new value
	 */
    public void setValue(String v)
    {   myValue = v;   }

	/**
	 * Getter method.
	 * 
	 * @return the value
	 */
    public String getValue()
    {   return myValue;   }

	/**
	 * Setter method.
	 * 
	 * @param c the new count
	 */
    public void setCount(int c)
    {   myCount = c;   }

	/**
	 * Getter method.
	 * 
	 * @return the count
	 */
    public int getCount()
    {   return myCount;   }

	/**
	 * Setter method.
	 * 
	 * @param min the new mininum
	 */
    public void setMin(double min)
    {   myMin = min;   }

	/**
	 * Getter method.
	 * 
	 * @return the minimum
	 */
    public double getMin()
    {   return myMin;   }

	/**
	 * Setter method.
	 * 
	 * @param max the new maximum
	 */
    public void setMax(double max)
    {   myMax = max;   }

	/**
	 * Getter method.
	 * 
	 * @return the maximum
	 */
    public double getMax()
    {   return myMax;   }
}
/*
 * Historie
 * --------
 * 
 * $Log: ValueCount.java,v $
 * Revision 1.3  2006/04/11 14:10:10  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:10  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:04  hakenjos
 * Initial version!
 *
 */


/*
 * Old Historie
 * ------------
 *
 * Revision 1.5  2002/10/23 13:23:19  euler
 * New Javadoc comments
 *
 * Revision 1.4  2002/10/08 18:07:56  scholz
 * Prepared code for parallel execution of multiple compile-Threads.
 * Calls to static fields like DB.m4Db were removed. Now each
 * Thread has its own DB object, reachable via
 * CompilerAccessLogic or Case.
 * The methods getCase() and getM4Db() were added to M4Object.
 * The static methods of Parameter now need an additional
 * parameter of type DB.
 * All direct calls from Operators to these Parameter methods were
 * removed.
 * All old load() and print() routines were removed.
 * The static calls to Print were removed. Now CompilerAccessLogic
 * references a valid Print object for the current Thread. This is
 * reachable via Case. The methods doPrint for messages and
 * Exceptions were added to M4Object.
 * The Print mechanism is not fully functional, yet.
 * A getStatus method was added to the Interface. It is not
 * functional yet for multiple Threads.
 *
 * Status: Compiles.
 *
 * Revision 1.3  2002/07/11 08:36:34  euler
 * Changed printing of messages.
 *
 * Revision 1.2  2002/05/07 12:15:19  euler
 * First M4 extensions, does not yet compile
 *
 * Revision 1.1  2002/04/30 13:00:26  wiese
 * compileable version
 *
 * Revision 1.6  2002/04/19 15:23:12  wiese
 * Initialversion nach der uebergabe
 *
 */
