/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.utils;
import java.util.Collection;

import edu.udo.cs.miningmart.m4.core.BaseAttribute;
import edu.udo.cs.miningmart.m4.core.M4Object;
import edu.udo.cs.miningmart.m4.core.MultiColumnFeature;
import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * Helper class for standard communication between <code>MultiColumnFeature</code> (container)
 * and <code>BaseAttribute</code>.
 * 
 * @author Martin Scholz
 * @version $Id: InterM4MCFeatureBaseAttribute.java,v 1.3 2006/04/11 14:10:09 euler Exp $
 */
public class InterM4MCFeatureBaseAttribute extends InterM4Communicator {
	/**
	 * @param baseattribute a <code>BaseAttribute</code>
	 * @return the <code>BaseAttribute</code>'s <code>MultiColumnFeature</code>
	 * 
	 * @see InterM4Communicator#getSingleRef(M4Object)
	 */
	public Object getSingleRef(M4Object baseattribute) throws M4Exception {
		return ((BaseAttribute) baseattribute).getMCFeature();
	}

	/**
	 * @param mcfeature a <code>MultiColumnFeature</code>
	 * @return the <code>MultiColumnFeature</code>'s <code>Collection</code> of
	 * <code>BaseAttribute</code>s
	 * 
	 * @see InterM4Communicator#getCollection(M4Object)
	 */
	public Collection getCollection(Object mcfeature) throws M4Exception {
		return ((MultiColumnFeature) mcfeature).getBaseAttributes();
	}

	/**
	 * @param baseattribute a <code>BaseAttribute</code>
	 * @param mcfeature a <code>MultiColumnFeature</code>
	 * @see InterM4Communicator#setSingleRefPrimitive(M4Object, M4Object)
	 */
	public void setSingleRefPrimitive(M4Object baseattribute, Object mcfeature) throws M4Exception {
		((BaseAttribute) baseattribute).primitiveSetMCFeature((MultiColumnFeature) mcfeature);
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: InterM4MCFeatureBaseAttribute.java,v $
 * Revision 1.3  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:03  hakenjos
 * Initial version!
 *
 */
