/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.utils;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.Key;
import edu.udo.cs.miningmart.m4.core.KeyMember;
import edu.udo.cs.miningmart.m4.core.M4Object;

/**
 * Helper class for standard communication between <code>Key</code> (container)
 * and <code>Keymember</code>.
 * 
 * @author Timm Euler
 * @version $Id: InterM4KeyKeymember.java,v 1.3 2006/04/11 14:10:10 euler Exp $
 */
public class InterM4KeyKeymember extends InterM4Communicator
{
	/**
	 * @param keymember a <code>KeyMember</code>
	 * @return the <code>Keymember</code>'s <code>Key</code>
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4Communicator#getSingleRef(M4Object)
	 */
	Object getSingleRef(M4Object keymember) throws M4Exception
	{	return ((KeyMember) keymember).getTheKey(); 	}

	/**
	 * @param key a <code>Key</code>
	 * @return the <code>Key</code>'s <code>Collection</code>
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4Communicator#getCollection(Object)
	 */
	Collection getCollection(Object key) throws M4Exception
	{	return ((Key) key).getMembers();   }

	/**
	 * @param keymember a <code>KeyMember</code>
	 * @param key a <code>Key</code>
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4Communicator#setSingleRefPrimitive(M4Object, Object)
	 */
	void setSingleRefPrimitive(M4Object keymember, Object key)
		throws M4Exception
	{   ((KeyMember) keymember).primitiveSetKey((Key) key);   }

}
/*
 * Historie
 * --------
 * 
 * $Log: InterM4KeyKeymember.java,v $
 * Revision 1.3  2006/04/11 14:10:10  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:10  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:04  hakenjos
 * Initial version!
 *
 */
