/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.utils;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.Docu;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.M4Object;

/**
 * Helper class for standard communication between <code>M4Data</code> 
 * and <code>Docu</code>.
 * 
 * @author Timm Euler
 * @version $Id: InterM4DataToDocu.java,v 1.3 2006/04/11 14:10:09 euler Exp $
 */
public class InterM4DataToDocu extends InterM4ObjectToObject
{
	/**
	 * @param m4data an M4Data object
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4ObjectToObject#getFirstSingleRef(M4Object)
	 */
	M4Object getFirstSingleRef(M4Object m4data) throws M4Exception
	{	return ((M4Data) m4data).primitiveGetDocObject();	}

	/**
	 * @param doc a Docu object
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4ObjectToObject#getSecondSingleRef(M4Object)
	 */
	M4Object getSecondSingleRef(M4Object doc) throws M4Exception
	{   return (M4Data) ((Docu) doc).getM4Object();   }

	/**
	 * @param m4data an M4Data object
	 * @param doc a Docu object
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4ObjectToObject#setFirstSingleRefPrimitive(M4Object, M4Object)
	 */
	void setFirstSingleRefPrimitive(M4Object m4data, M4Object doc)
		throws M4Exception
	{   ((M4Data) m4data).primitiveSetDocObject((Docu) doc);  }

	/**
	 * @param doc a Docu object
	 * @param m4data an M4Data object
	 * 
	 * @see edu.udo.cs.miningmart.m4.utils.InterM4ObjectToObject#setSecondSingleRefPrimitive(M4Object, M4Object)
	 */
	void setSecondSingleRefPrimitive(M4Object doc, M4Object m4data)
		throws M4Exception
	{   ((Docu) doc).primitiveSetM4Object((edu.udo.cs.miningmart.m4.M4Data) m4data);  }
}
/*
 * Historie
 * --------
 * 
 * $Log: InterM4DataToDocu.java,v $
 * Revision 1.3  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:04  hakenjos
 * Initial version!
 *
 */
