/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.utils;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.Columnset;
import edu.udo.cs.miningmart.m4.core.PrimaryKey;
import edu.udo.cs.miningmart.m4.core.M4Object;

/**
 * Helper class for standard communication between <code>Columnset</code> 
 * (first object) and <code>PrimaryKey</code> (second object). 
 * 
 * @author Martin Scholz
 * @version $Id: InterM4ColumnsetPrimaryKey.java,v 1.3 2006/04/11 14:10:10 euler Exp $
 */
public class InterM4ColumnsetPrimaryKey extends InterM4ObjectToObject {

	/**
	 * This method should call the getter in the first object which
	 * returns the reference to the second object.
	 * 
	 * @param first the first object
	 * @return a reference to the second object
	 * */		
	public M4Object getFirstSingleRef(M4Object columnset) throws M4Exception {
		return (PrimaryKey) ((Columnset) columnset).getPrimaryKey();
	}
	
	/**
	 * This method should call the getter in the second object which
	 * returns the reference to the first object.
	 * 
	 * @param second the second object
	 * @return a reference to the first object
	 * */		
	public M4Object getSecondSingleRef(M4Object primKey) throws M4Exception {
		return (Columnset) ((PrimaryKey) primKey).getColumnset();
	}

	/**
	 * This method should call the primitive setter for the first object,
	 * setting the reference to the second object.
	 *
	 * @param first the first object
	 * @param second the second object
	 */		
	public void setFirstSingleRefPrimitive(M4Object columnset, M4Object primKey) throws M4Exception {
		((Columnset) columnset).primitiveSetPrimaryKey((PrimaryKey) primKey);
	}

	/**
	 * This method should call the primitive setter for the second object,
	 * setting the reference to the first object.
	 *
	 * @param second the second object
	 * @param first the first object
	 */		
	public void setSecondSingleRefPrimitive(M4Object primKey, M4Object columnset) throws M4Exception {
		((PrimaryKey) primKey).primitiveSetColumnset((Columnset) columnset);
	}
	
	/*
	 * @param key a <code>Key</code>
	 * @return the current container object
	 * @see InterM4Communicator#getSingleRef(M4Object)
	 *
	public Object getSingleRef(M4Object key) throws M4Exception {
		return ((Key) key).getPrimaryKeyColumnSet();
	}
	
	/*
	 * @param columnset a <code>Columnset</code>
	 * @return the container object's collection
	 * 
	 * @see InterM4Communicator#getCollection(M4Object)
	 *
	public Collection getCollection(Object columnset) throws M4Exception {
		return ((Columnset) columnset).getPrimaryKeys();
	}
	
	/*
	 * @param key a <code>Key</code>
	 * @param columnset a <code>Columnset</code>
	 * 
	 * @see InterM4Communicator#setSingleRefPrimitive(M4Object, M4Object)
	 *
	public void setSingleRefPrimitive(M4Object key, Object columnset) throws M4Exception {
		((Key) key).primitiveSetPrimaryKeyColumnset((Columnset) columnset);
	}
	*/
}
/*
 * Historie
 * --------
 * 
 * $Log: InterM4ColumnsetPrimaryKey.java,v $
 * Revision 1.3  2006/04/11 14:10:10  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:03  hakenjos
 * Initial version!
 *
 */
