/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * This class realises the primary key functionality.
 * 
 * @author Timm Euler
 * @version $Id: PrimaryKey.java,v 1.4 2006/04/11 14:10:14 euler Exp $
 */
public class PrimaryKey extends Key implements edu.udo.cs.miningmart.m4.PrimaryKey
{
	private Columnset myColumnset;
	
	/**
	 * Constructor for PrimaryKey.
	 * 
	 * @param m4Db The DB object
	 */
	public PrimaryKey(DB m4Db)
	{	super(m4Db);	}
	
	/**
	 * @see edu.udo.cs.miningmart.m4.core.M4Data#getObjectsInNamespace(Class)
	 */
	protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
		return null;
	}

	/**
	 * @see edu.udo.cs.miningmart.m4.hci.Key#getColumn(KeyMember)
	 */
	protected Column getColumn(KeyMember km)
	{   return (Column) km.getPrimaryKeyColumn();	}

	/**
	 * @see miningmart.m4.Key#getColumnSet()
	 */
	public edu.udo.cs.miningmart.m4.Columnset getColumnset()
	{   return this.myColumnset; 	}

	/**
	 * @see miningmart.m4.Key#setColumnSet(ColumnSet)
	 */
	public void setColumnset(edu.udo.cs.miningmart.m4.Columnset columnSet) 
	       throws M4Exception { 
		Columnset.cspkey.removeReferences(this.myColumnset, this);
		Columnset.cspkey.setReciprocalReferences((Columnset) columnSet, this);
	}	

	public void setPrimaryKeyColumnset(edu.udo.cs.miningmart.m4.Columnset pkCs) throws M4Exception {
		this.setColumnset(pkCs);
	}
	public void setForeignKeyColumnset(edu.udo.cs.miningmart.m4.Columnset fkCs) throws M4Exception {
		// ignore this, a primary key does not have a foreign key columnset!
	}
	public void primitiveSetPrimaryKeyColumnset(edu.udo.cs.miningmart.m4.Columnset pkCs) throws M4Exception {
		this.setDirty();
		this.primitiveSetColumnset(pkCs);
	}
	public void primitiveSetForeignKeyColumnset(edu.udo.cs.miningmart.m4.Columnset fkCs) throws M4Exception {
		// ignore this, a primary key does not have a foreign key columnset!		
	}
	public edu.udo.cs.miningmart.m4.Columnset getPrimaryKeyColumnset() throws M4Exception {
		return this.getColumnset();
	}
	public edu.udo.cs.miningmart.m4.Columnset getForeignKeyColumnset() throws M4Exception {
		// a primary key never has a foreign key columnset
		return null;
	}
	
	/**
	 * Primitive setter. Do not use!
	 * 
	 * @param cs New Columnset
	 */
	public void primitiveSetColumnset(edu.udo.cs.miningmart.m4.Columnset cs) {
		this.setDirty();
		this.myColumnset = (Columnset) cs;
	}
	
	/**
	 * @see miningmart.m4.Key#removeColumn(String)
	 */
	public void removeColumn(String name) throws M4Exception {		
		super.removeMemberByPrimaryColumnName(name); 
	}

	/**
	 * @see miningmart.m4.PrimaryKey#addColumn(Column)
	 */
	public void addColumn(edu.udo.cs.miningmart.m4.Column column) throws M4Exception
	{   
		try {
			KeyMember km = (KeyMember) this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.KeyMember.class);
			km.setForeignKeyColumn(null);
			// km.setTheKey(this);
			km.setPrimaryKeyColumn(column);
			// what about the new member's m4 id?
			// must be dealt with in this.store()?
			this.addMember(km);
		}
		catch (M4Exception m4e)
		{   throw new M4Exception("PrimaryKey.addColumn: Error adding Column " +
			                      ((Column) column).getId() + " to Primary Key " +
			                      this.getId() + ": " + m4e.getMessage());
		}
	}

	public Collection getAllColumns() throws M4Exception {
		Iterator it = this.getMembers().iterator();
		Vector columns = new Vector();
		while (it.hasNext()) {
			KeyMember km = (KeyMember) it.next();
			columns.add(km.getPrimaryKeyColumn());
		}
		columns.trimToSize();
		return columns;
	}	
	
	/**
	 * @see miningmart.m4.PrimaryKey#copy(ColumnSet)
	 */
	public edu.udo.cs.miningmart.m4.PrimaryKey copy(edu.udo.cs.miningmart.m4.Columnset newColumnSet)
		throws M4Exception
	{
		PrimaryKey theCopy = new PrimaryKey(this.getM4Db());
		try {
			theCopy.setColumnset(newColumnSet);			
			String nameOfCopy = newColumnSet.getValidName(this.getName(), PrimaryKey.class);
			theCopy.setName(nameOfCopy);
			theCopy.setMembers(this.getMembers());
		}
		catch (M4Exception m4e)
		{   throw new M4Exception("Could not copy PrimaryKey " + this.getId() + 
			                      " to Columnset '" + newColumnSet.getName() + "': " + m4e.getMessage());
		}
		return theCopy;
	}

	/** @see M4Data#getDependentObjects */
	public Collection getDependentObjects() throws M4Exception {
		Collection ret = super.getDependentObjects();
		Columnset cs = (Columnset) this.getColumnset();
		if (cs != null)
			ret.add(cs);
		return ret;
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: PrimaryKey.java,v $
 * Revision 1.4  2006/04/11 14:10:14  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:13  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/01/06 16:25:04  euler
 * Updates and bugfixes in the delete-Mechanism for M4Data objects.
 *
 * Revision 1.1  2006/01/03 09:54:18  hakenjos
 * Initial version!
 *
 */
