/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.utils.InterM4Communicator;
import edu.udo.cs.miningmart.m4.utils.InterM4ParameterObjectParameter;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;

/**
 * Superclass for all <code>M4Object</code>s that might be a <code>Step</code>s parameter.
 * 
 * @author Martin Scholz
 * @version $Id: ParameterObject.java,v 1.4 2006/04/11 14:10:14 euler Exp $
 */
abstract public class ParameterObject extends GraphicalM4Object implements XmlInfo, edu.udo.cs.miningmart.m4.ParameterObject {
	
	static final InterM4Communicator parObj2par = new InterM4ParameterObjectParameter();
	
	/** Holds the <code>Parameter</code> objects referencing this <code>ParameterObject</code> */
	private final Vector referencedByParameter = new Vector();
	
	private boolean allParametersLoaded = false;
	
	public ParameterObject(DB db) {
		super(db);	
	}
	
	/**
	 * Informs this object that a <code>Parameter</code> references it.
	 * @param par the <code>Parameter</code>
	 */
	public void addParameterReference(edu.udo.cs.miningmart.m4.Parameter par) throws M4Exception {
		
		// do not check for existing names in this case, because a parameterObject
		// may be a parameter with the same name in different steps
		// parObj2par.checkNameExists(par, this);
		
		parObj2par.add(this, (edu.udo.cs.miningmart.m4.core.Parameter) par);
	}
	
	/** 
	 * @return a <code>Collection</code> of all <code>Parameter</code>s
	 * referencing this object
	 * */
	public Collection getParameterReferences() throws M4Exception {
		if ( ! allParametersLoaded && ( ! this.isNew())) {
			this.allParametersLoaded = true;
            this.readParametersForParObjectFromDB();
        }
		return this.referencedByParameter;
	}
	
	/**
	 * @param a <code>Parameter</code> no longer referencing this object 
	 * @return <code>true</code> if the <code>Parameter</code> specified
	 * could be removed from the list of referencing <code>Parameter</code>s
	 */
	public boolean removeParameterReference(edu.udo.cs.miningmart.m4.Parameter par) throws M4Exception {
		return parObj2par.remove(this, (edu.udo.cs.miningmart.m4.core.Parameter) par);
	}

	private void readParametersForParObjectFromDB() throws M4Exception
	{
		Iterator it = this.getObjectsReferencingMe(Parameter.class).iterator();
		while (it.hasNext()) {
			this.addParameterReference((edu.udo.cs.miningmart.m4.Parameter) it.next());
		}
	}
	
	/** @see M4Data#getDependentObjects */
	public Collection getDependentObjects() throws M4Exception {
		Collection ret = super.getDependentObjects();
		ret.addAll(this.getParameterReferences());
		return ret;
	}
	
	/** @see M4Data#removeAllM4References() */
	protected void removeAllM4References() throws M4Exception {
		ParameterObject.parObj2par.setCollectionTo(this, new Vector(0));
	}
	
}

/*
 * Historie
 * --------
 * 
 * $Log: ParameterObject.java,v $
 * Revision 1.4  2006/04/11 14:10:14  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:13  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:14  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:18  hakenjos
 * Initial version!
 *
 */
