/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.core;
import java.util.Collection;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;

/**
 * Corresponds to M4 table ConceptIsA_T.
 * 
 * @author Martin Scholz
 * @version $Id: ConceptInheritance.java,v 1.4 2006/04/11 14:10:14 euler Exp $
 */
public class ConceptInheritance extends M4Data implements XmlInfo {

	/** The name of the corresponding M4 table. */
	public static final String M4_TABLE_NAME = "conceptisa_t";

	/** db level: name of the attribute specifying the projection's id */
	public static final String ATTRIB_CONINHERIT_ID = "cisa_id";	

	/** db level: name of the attribute specifying the from-concept's id */
	public static final String ATTRIB_SUB_CONCEPT = "cisa_subconid";	

	/** db level: name of the attribute specifying the to-concept's id */
	public static final String ATTRIB_SUPER_CONCEPT = "cisa_superconid";	



	/** Cache for getM4Info() */
	public static M4Info m4Info = null;

	/** @see M4Table.getM4TableName() */
	public String getM4TableName() {
		return M4_TABLE_NAME;	
	}

	/** @see M4Table.getIdAttributeName() */
	public String getIdAttributeName() {
		return ATTRIB_CONINHERIT_ID;
	}

	/** @see M4Table.getM4Info() */
	public M4Info getM4Info() {
		if (m4Info == null) {
			M4InfoEntry[] m4i = {
				new M4InfoEntry(ATTRIB_CONINHERIT_ID, "getId",           "setId",                    long.class,    NOT_NULL),
				new M4InfoEntry(ATTRIB_SUB_CONCEPT,   "getSubConcept",   "primitiveSetSubConcept",   edu.udo.cs.miningmart.m4.Concept.class, NOT_NULL),
				new M4InfoEntry(ATTRIB_SUPER_CONCEPT, "getSuperConcept", "primitiveSetSuperConcept", edu.udo.cs.miningmart.m4.Concept.class, NOT_NULL)
			};
			m4Info = new M4Info(m4i);
		}
		return m4Info;
	}

	/** Cache for getXmlInfo() */
	private static M4Info xmlInfo = null;

	/** @see XmlInfo.getXmlInfo() */

	public M4Info getXmlInfo() {
		if (xmlInfo == null) {
			M4InfoEntry[] m4i = {
				new M4InfoEntry("SubConcept",   "getSubConcept",   "setSubConcept",   edu.udo.cs.miningmart.m4.Concept.class),
				new M4InfoEntry("SuperConcept", "getSuperConcept", "setSuperConcept", edu.udo.cs.miningmart.m4.Concept.class)
			};
			xmlInfo = new M4Info(m4i);
		}
		return xmlInfo;
	}

	// the instance fields:
	private Concept subConcept;
	private Concept superConcept;


	public ConceptInheritance(DB db) { super(db); }


	/**
	 * @see M4Object#print()
	 */
	public void print() {
		Concept fromC = (Concept) this.getSubConcept();
		Concept toC   = (Concept) this.getSuperConcept();
		
		doPrint(Print.M4_OBJECT, "Concept Inheritance (Id = " + this.getId() + ";"
				+ " Sub-Concept's ID: " + (fromC == null ? "<none>" : "<" + fromC.getId() + ">") + "; "
				+ " Super-Concept's ID: " + (toC == null ? "<none>" : "<" + toC.getId()) + ">" + ")"
				);
	}
	
	/**
	 * @see edu.udo.cs.miningmart.m4.core.M4Data#getObjectsInNamespace(Class)
	 */
	protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
		return null;
	}

	/**
	 * Getter method.
	 * 
	 * @return the <code>Concept</code> stored as the Sub-Concept in
	 */
	public edu.udo.cs.miningmart.m4.Concept getSubConcept() {
		return this.subConcept;
	}

	/**
	 * Getter method.
	 * 
	 * @return the <code>Concept</code> stored as the Super-Concept
	 */		
	public edu.udo.cs.miningmart.m4.Concept getSuperConcept() {
		return this.superConcept;		
	}

	/**
	 * Setter method for the Sub-Concept
	 * @param subConcept the <code>Concept</code> to be set as the new
	 *        Sub-Concept
	 */
	public void setSubConcept(edu.udo.cs.miningmart.m4.Concept subConcept) throws M4Exception {
		Concept.conInheritSub.updateReferenceTo(this, subConcept);
	}

	/**
	 * Setter method for the Super-Concept
	 * @param superConcept the <code>Concept</code> to be set as the new
	 *        Super-Concept
	 */
	public void setSuperConcept(edu.udo.cs.miningmart.m4.Concept superConcept) throws M4Exception {
		Concept.conInheritSuper.updateReferenceTo(this, superConcept);
	}
	
	/**
	 * Primitive setter, do not use it!
	 * @param subConcept the new From-Concept to be set
	 */
	public void primitiveSetSubConcept(edu.udo.cs.miningmart.m4.Concept subConcept) {
		this.setDirty();
		this.subConcept = (Concept) subConcept;
	}

	/**
	 * Primitive setter, do not use it!
	 * @param superConcept the new From-Concept to be set
	 */
	public void primitiveSetSuperConcept(edu.udo.cs.miningmart.m4.Concept superConcept) {
		this.setDirty();
		this.superConcept = (Concept) superConcept;
	}

	/** @see M4Data#removeAllM4References() */
	protected void removeAllM4References() throws M4Exception {
		this.setSubConcept(null);
		this.setSuperConcept(null);
	}

}
/*
 * Historie
 * --------
 * 
 * $Log: ConceptInheritance.java,v $
 * Revision 1.4  2006/04/11 14:10:14  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/04/03 09:32:53  euler
 * Improved Export/Import of Projections
 * and Subconcept links.
 *
 * Revision 1.1  2006/01/03 09:54:17  hakenjos
 * Initial version!
 *
 */
