/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4.core;

import java.util.Collection;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;

/**
 * @author Martin Scholz
 * @version $Id: ColumnStatistics2.java,v 1.3 2006/04/11 14:10:14 euler Exp $
 */
public class ColumnStatistics2 extends M4Data implements XmlInfo, edu.udo.cs.miningmart.m4.ColumnStatistics2 {

	// ***** Database constants for the Column table *****
	public static final String M4_TABLE_NAME = "colstatist2_t";
	public static final String ATTRIB_COLSTAT_ID   = "colst2_id";
	public static final String ATTRIB_COLST2_COLID = "colst2_colid";
	public static final String ATTRIB_COLST2_VALUE = "colst2_distvalue";
	public static final String ATTRIB_COLST2_COUNT = "colst2_distcount";
	public static final String ATTRIB_COLST2_MIN   = "colst2_distmin";
	public static final String ATTRIB_COLST2_MAX   = "colst2_distmax";

	/** Cache for getM4Info() */
	public static M4Info m4Info = null;

	/** @see M4Table.getM4TableName() */
	public String getM4TableName() {
		return M4_TABLE_NAME;	
	}

	/** @see M4Table.getIdAttributeName() */
	public String getIdAttributeName() {
		return ATTRIB_COLSTAT_ID;
	}

	/** @see M4Table.getM4Info() */
	public M4Info getM4Info() {
		if (m4Info == null) {
			M4InfoEntry[] m4i = {
				new M4InfoEntry(ATTRIB_COLSTAT_ID,   "getId",                  "setId",     	         long.class,   NOT_NULL),
				new M4InfoEntry(ATTRIB_COLST2_COLID, "getTheColumn",           "primitiveSetColumn",     edu.udo.cs.miningmart.m4.Column.class, NOT_NULL),
				new M4InfoEntry(ATTRIB_COLST2_VALUE, "getDistributionValue",   "setDistributionValue",   String.class, NOT_NULL),
				new M4InfoEntry(ATTRIB_COLST2_COUNT, "getDistributionCount",   "setDistributionCount",   int.class,    NOT_NULL),
				new M4InfoEntry(ATTRIB_COLST2_MIN,   "getDistributionMin",     "setDistributionMin",     Double.class),
				new M4InfoEntry(ATTRIB_COLST2_MAX,   "getDistributionMax",     "setDistributionMax",     Double.class)
			};
			m4Info = new M4Info(m4i);
		}
		return m4Info;
	}

	// ***** Method from the XmlInfo interface *****

	/** Cache for getXmlInfo() */
	private static M4Info xmlInfo = null;

	/** @see XmlInfo.getXmlInfo() */
	public M4Info getXmlInfo() {
		if (xmlInfo == null) {
			M4InfoEntry[] m4i = {
				new M4InfoEntry("Column",  "getTheColumn",           "setTheColumn",           edu.udo.cs.miningmart.m4.Column.class),
				new M4InfoEntry("Value",   "getDistributionValue",   "setDistributionValue",   String.class),
				new M4InfoEntry("Count",   "getDistributionCount",   "setDistributionCount",   int.class),
				new M4InfoEntry("Minimum", "getDistributionMin",     "setDistributionMin",     Double.class),
				new M4InfoEntry("Maximum", "getDistributionMax",     "setDistributionMax",     Double.class)
			};
			xmlInfo = new M4Info(m4i);
		}
		return xmlInfo;
	}

	// *****
		
	private Column myColumn;
	
	private String theDistValue;
	private int count;
	private Double min, max;

	public ColumnStatistics2(DB db) { super(db); }
	
	/**
	 * @see edu.udo.cs.miningmart.m4.core.M4Data#getObjectsInNamespace(Class)
	 */
	protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
		return null;
	}

	public String getDistributionValue() {
		return this.theDistValue;
	}

	public void setDistributionValue(String distributionValue) {
		this.setDirty();
		this.theDistValue = distributionValue;
	}

	public int getDistributionCount() {
		return this.count;
	}

	public void setDistributionCount(int distributionCount)	{
		this.setDirty();
		this.count = distributionCount;
	}

	public Double getDistributionMin() {
		return this.min;
	}

	public double getDistributionMinimum() {
		return (this.min == null ? 0 : this.min.doubleValue());
	}

	public void setDistributionMin(Double distributionMinimum) {
		this.setDirty();
		this.min = distributionMinimum;
	}

	public void setDistributionMinimum(double distributionMinimum) {
		this.setDistributionMin(new Double(distributionMinimum));
	}

	public Double getDistributionMax() {
		return this.max;
	}

	public double getDistributionMaximum() {
		return (this.max == null ? 0 : this.max.doubleValue());
	}

	public void setDistributionMax(Double distributionMaximum) {
		this.setDirty();
		this.max = distributionMaximum;
	}

	public void setDistributionMaximum(double distributionMaximum) {
		this.setDistributionMax(new Double(distributionMaximum));
	}

	public edu.udo.cs.miningmart.m4.Column getTheColumn() {
		return this.myColumn;
	}

	public void setTheColumn(edu.udo.cs.miningmart.m4.Column column) throws M4Exception {
		Column.colCstat2.updateReferenceTo(this, column);
	}

	public void primitiveSetColumn(edu.udo.cs.miningmart.m4.Column column) {
		this.setDirty();
		this.myColumn = (Column) column;
	}

	public void print() {}
	
	/** Remove the Column reference of this statistic object. */
    public void removeAllM4References() throws M4Exception {
    	this.setTheColumn(null);
    }
	
 }
/*
 * Historie
 * --------
 * 
 * $Log: ColumnStatistics2.java,v $
 * Revision 1.3  2006/04/11 14:10:14  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:13  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:18  hakenjos
 * Initial version!
 *
 */
