/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: Value.java,v 1.3 2006/04/11 14:10:12 euler Exp $
 */
public interface Value extends ParameterObject {

	//methods from core

	/**
	 * Setter method.
	 * 
	 * @param t the new type
	 */
	public void setType(long t);

	/**
	 * Setter method.
	 * 
	 * @param t the new type
	 */
	public void setTypeL(Long t);

	/**
	 * Getter method.
	 * 
	 * @return the type
	 */
	public long getType();

	/**
	 * Getter method.
	 * 
	 * @return the type
	 */
	public Long getTypeL();

	/**
	 * Setter method.
	 * 
	 * @param v the new value
	 */
	public void setValue(String v);

	public void setType(String conceptualDatatypeName) throws M4Exception;
	
	public String getTypeName() throws M4Exception;

	/**
	 * This setter method cares about conversion from database <code>String</code>
	 * formats and should only be used during load. The value type needs to be set
	 * already!
	 * 
	 * @param value the value in database <code>String</code> representation
	 */
	public void setRawValue(String value);

	/**
	 * Getter method.
	 * 
	 * @return the value
	 */
	public String getValue();

	/** 
	 * @return <i>true</i> iff the value can be parsed to <i>Long</i>. 
	 */
	public boolean isLong();

	/** 
	 * @return <i>true</i> iff the value can be parsed to <i>Double</i>. 
	 */
	public boolean isDouble();

	/** 
	 * @return a <i>Long</i> object if the value <i>isLong()</i>, <i>null</i> otherwise. 
	 */
	public Long getLong();

	/** 
	 * @return a <i>Double</i> object if the value <i>isDouble()</i>, <i>null</i> otherwise. 
	 */
	public Double getDouble();
}
/*
 * Historie
 * --------
 * 
 * $Log: Value.java,v $
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
