/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: Relation.java,v 1.5 2006/04/11 14:10:12 euler Exp $
 */
public interface Relation extends ParameterObject{

	//methods from core
	
	/**
	 * Setter method.
	 * 
	 * @param c the new value
	 */
    public void setTheToConcept(Concept c) throws M4Exception;

	/**
	 * Getter method.
	 * 
	 * @return the value
	 */
    public Concept getTheToConcept() throws M4Exception;

	/**
	 * Setter method.
	 * 
	 * @param c the new value
	 */
    public void setTheFromConcept(Concept c) throws M4Exception;

	/**
	 * Getter method.
	 * 
	 * @return the value
	 */
    public Concept getTheFromConcept() throws M4Exception;
    
    /**
     * This method creates a Columnset that represents the inner join
     * resulting from joining the FromConcept and the ToConcept. The M4
     * Columns are also created. However, the view corresponding to the
     * new Columnset is not created in the database.
     * 
     * @return a Columnset
     * @throws M4Exception
     */
    public Columnset getResultOfJoin() throws M4Exception;

    /**
     * Returns all Steps in the Case that use this Relation as
     * an input.
     * 
     * @return a Collection of Steps
     */
    public Collection getStepsWhereThisIsInputRelation() throws M4Exception;
	
	/**
	 * Setter method.
	 * 
	 * @param newToKey the new toKey
	 */
    public void setToKey(ForeignKey newToKey) throws M4Exception;
	
	/**
	 * Getter method.
	 * 
	 * @return the value
	 */
    public ForeignKey getToKey() throws M4Exception;

    public void removeToKey() throws M4Exception;
    
	/**
	 * Setter method.
	 * 
	 * @param newFromKey the new FromKey
	 */
    public void setFromKey(ForeignKey newFromKey) throws M4Exception;

	/**
	 * Getter method.
	 * 
	 * @return the value
	 */
    public ForeignKey getFromKey() throws M4Exception;
    
    public void removeFromKey() throws M4Exception;

    /**
     * @return The Columnset that realizes this relation if it is an n:m
     *          relation. For 1:n relations, null is returned.
     */
    public Columnset getCrossLinkColumnSet() throws M4Exception;

	/**
	 * Setter method.
	 * 
	 * @param cs The new cross columnset for the n:m relation.
	 */
    public void setCrossLinkColumnSet(Columnset cs) throws M4Exception;	
	
    /**
     * Returns true iff this Relation models a 1:n relationship.
     */
	public boolean isOneToManyRelation();

    /**
     * Returns true iff this Relation models an n:m relationship.
     */
	public boolean isManyToManyRelation();
	
	//methods from old interface
	
  /* Constants 

  public static final String FROM_ENDPOINT  = "FromEndpoint";
  public static final String TO_ENDPOINT    = "ToEndpoint";
  public static final String FROM_CTRLPOINT = "FromCtrlpoint";
  public static final String TO_CTRLPOINT   = "ToCtrlpoint";

  /* Attribute methods */

  // String getSubRelationRestriction(); // TE: future stuff

  // void setSubRelationRestriction(String subRelationshipRestriction) throws M4Exception; // TE: future stuff

  /**
   * This method returns information about the relational validity of the object. The relational validity is managed at the
   * database level by triggers. The returned value denotes if the object is valid on the relational level or not.
   */
  boolean isRelationallyValid();


  /* Association methods */
  
  public Collection getSubRelations(); // TE: future stuff  
  public Relation getSuperRelation();
  public void setSuperRelation(Relation superRelationship) throws M4Exception;
  
  /**
   * Remove the link to the superRelationship. The superRelationship itself is not removed.
   */
  public void removeSuperRelation() throws M4Exception;
  public void addSubRelationship(Relation relationship) throws M4Exception;
  public Relation getSubRelation(String name);
  public Collection getAllSubRelationships();
  public void removeSubRelationship(String name) throws M4Exception;
  public void removeAllSubRelationships() throws M4Exception;

  /**
   * Creates a ColumnSet that will be connected to this Relation. The
   * name of the ColumnSet must be unique for this Relation.
   * @param name The name for the new ColumnSet.
   * @return The new ColumnSet object.
   * @throws M4Exception when an error occurs during creation of the object.
   */
  public Columnset createCrossLinkColumnset(String name, String schema, String type)
         throws M4Exception;

  /**
   * Removes the ColumnSet for this Relation. It is also removed from the M4 Schema.
   */
  void removeCrossLinkColumnset() throws M4Exception;


  /**
   * Sets the key fields that define a many-to-many relationship on the relational
   * level for this Relationship. For a many-to-many relationship a ColumnSet
   * and two foreignKeys are needed. The ColumnSet represents the crosstable
   * needed to implement the many-to-many relationship. The crosstable ColumnSet
   * is bound to this Relationship with the createColumnSet method.
   * <p>
   * The foreignKey of the ColumnSet of the fromConcept is set as the
   * fromKey. The foreignKey of the ColumnSet of the toConcept is set
   * as the toKey.
   * <p>
   * @param fromFK The foreignKey corresponding to the FromConcept.
   * @param toFK The foreignKey corresponding to the ToConcept.
   *
   * @throws StorageException If key doesn't exist yet, this exception may be
   * propagated from ForeignKey.store().
   */
  void setM2mKeys(ForeignKey fromFK, ForeignKey toFK) throws M4Exception;

  /* Other methods */

  Relation copy(Concept fromConcept, Concept toConcept) throws M4Exception;	
}
/*
 * Historie
 * --------
 * 
 * $Log: Relation.java,v $
 * Revision 1.5  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/01/05 14:11:37  euler
 * Bugfixes
 *
 * Revision 1.2  2006/01/03 10:43:14  euler
 * Added methods isOne/ManyToManyRelation
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
