/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: Projection.java,v 1.3 2006/04/11 14:10:12 euler Exp $
 */
public interface Projection extends M4Data {
	
	/**
	 * Getter method.
	 * 
	 * @return the <code>Concept</code> stored as the From-Concept in
	 *         this <code>Projection</code>
	 */
	public Concept getFromConcept();

	/**
	 * Getter method.
	 * 
	 * @return the <code>Concept</code> stored as the To-Concept in
	 *         this <code>Projection</code>
	 */		
	public Concept getToConcept();

	/**
	 * Setter method for the From-Concept of this <code>Projection</code>
	 * @param fromConcept the <code>Concept</code> to be set as the new
	 *        From-Concept
	 */
	public void setFromConcept(Concept fromConcept) throws M4Exception;

	/**
	 * Setter method for the To-Concept of this <code>Projection</code>
	 * @param toConcept the <code>Concept</code> to be set as the new
	 *        To-Concept
	 */
	public void setToConcept(Concept toConcept) throws M4Exception;
	
	/**
	 * For a valid projection, the From concept must have all the features
	 * of the To concept (correspondence is determined by name), 
	 * and can have more. 
	 * 
	 * @return TRUE iff this projection represents a valid projection 
	 * (feature selection) from the from concept to the to concept.
	 * @throws M4Exception
	 */
	public boolean isValid() throws M4Exception;
}
/*
 * Historie
 * --------
 * 
 * $Log: Projection.java,v $
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
