/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * A PrimaryKey models the fact that some Columns of a 
 * Columnset enable a unique identification of each row
 * in that Columnset. That is, the combination of entries
 * of the Columns belonging to the PrimaryKey is enough to
 * identify each row. Each PrimaryKey belongs to exactly
 * one Columnset and can have a number of Columns, all of which
 * must belong to that Columnset.
 * 
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: PrimaryKey.java,v 1.3 2006/04/11 14:10:12 euler Exp $
 */
public interface PrimaryKey extends Key {

    void addColumn(Column column) throws M4Exception;

    PrimaryKey copy(Columnset newColumnSet) throws M4Exception;

    public Columnset getColumnset();

    public void setColumnset(Columnset columnSet) throws M4Exception;

	public Collection getAllColumns() throws M4Exception;

	public void removeAllColumns() throws M4Exception;

	public void removeColumn(String name) throws M4Exception;
}
