/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4Exception;


/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: ParameterObject.java,v 1.3 2006/04/11 14:10:12 euler Exp $
 */
public interface ParameterObject extends GraphicalM4Object{
	
	//methods from core

	/**
	 * Informs this object that a <code>Parameter</code> references it.
	 * @param par the <code>Parameter</code>
	 */
	public void addParameterReference(Parameter par) throws M4Exception;
	
	/** 
	 * @return a <code>Collection</code> of all <code>Parameter</code>s
	 * referencing this object
	 * */
	public Collection getParameterReferences() throws M4Exception;
	
	/**
	 * @param a <code>Parameter</code> no longer referencing this object 
	 * @return <code>true</code> if the <code>Parameter</code> specified
	 * could be removed from the list of referencing <code>Parameter</code>s
	 */
	public boolean removeParameterReference(Parameter par) throws M4Exception;
		
}
/*
 * Historie
 * --------
 * 
 * $Log: ParameterObject.java,v $
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:11  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:23  hakenjos
 * Initial version!
 *
 */
