/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import java.util.Collection;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: ParameterArray.java,v 1.3 2006/04/11 14:10:12 euler Exp $
 */
public interface ParameterArray {
	
	//methods from core

	/**
	 * Extends the array of ParameterObjects by the specified Parameter.
	 * Note, that the type of this Parameter has to be the same or a subclass
	 * of this ParameterArray's type!
	 * 
	 * The <code>Parameter</code> will also have a reference to this object
	 * after it has been added by this method.
	 * 
	 * After each invokation the array of ParameterObjects is invalidated and
	 * the active getter of this field will set it anew.
	 * 
	 * @param par the <code>Parameter</code> to be added
	 */
	public void addParameter(Parameter par) throws M4Exception;

	/**
	 * Inverts the <code>addParameter(Parameter)</code> functionality.
	 * The object specified is removed from the internal list of embedded
	 * <code>Paramter</code>s. The reference of the <code>Parameter</code> to
	 * this object is also deleted.
	 * @param par the <code>Parameter</code> to be deleted
	 * @return <code>true</code> if the object could be deleted
	 */
	public boolean removeParameter(Parameter par) throws M4Exception;

	/**
	 * @param  par a <code>Parameter</code>
	 * @return <code>true</code> if a <code>Parameter</code> with the same ID is
	 *         found in this <code>ParameterArray</code>
	 * */
	public boolean hasParameter(Parameter par) throws M4Exception;

	// ***** Getter and setter *****

	/**
	 * Gets the parameterType.
	 * @return Returns a short
	 */
	public short getParameterType();

	/**
	 * Gets the parameterType as the String constant used in class DB.
	 * @return Returns a String
	 */
	public String getParameterTypeS();
	
	/**
	 * @return the number of <code>Parameter</code>s this
	 * <code>ParameterArray</code> contains.
	 */
	public int size();

	/**
	 * @return the <code>Collection</code> of embedded <code>Parameter</code>
	 * objects.
	 */	
	public Collection getParameters();

	/**
	 * Active getter of the <code>parameterObjectArray</code>.
	 * @return Returns a <code>ParameterObject[]</code>
	 */
	public ParameterObject[] getParameterObjectArray() throws M4Exception;
}
/*
 * Historie
 * --------
 * 
 * $Log: ParameterArray.java,v $
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
