/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import java.util.Collection;
import java.util.Iterator;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: Operator.java,v 1.4 2006/04/11 14:10:12 euler Exp $
 */ 
public interface Operator extends M4Data{
	
	
	//methods from core

	// ***** Methods for loading *****

	/**
	 * Get an iterator.
	 * 
	 * @return an <code>Iterator</code> for the parameters stored in table <i>OP_PARAM_T</i>,
	 * represented as objects of type <code>OpParam</code>.
	 */
	public Iterator getOpParamsIterator() throws M4Exception;


	// ***** Getter and setter *****

	/**
	 * Setter method.
	 * @param r the new value
	 */
    public void setRealize(String r);

	/**
	 * Getter method.
	 * @return the value
	 */
    public String getRealize();

	/**
	 * Setter method.
	 * @param l the new value
	 */
    public void setLoopable(boolean l);

	/**
	 * Setter method.
	 * @param loopable the new value in the database <code>String</code>
	 *        representation
	 */
    public void setLoopable(String loopable);

	/**
	 * "Getter" method.
	 * @return the value
	 */
    public boolean isLoopable();

	/**
	 * "Getter" method.
	 * @return the value in database <code>String</code> representation
	 */
    public String getLoopable();

	/**
	 * Setter method.
	 * @param m the new value
	 */
    public void setManual(boolean m);

	/**
	 * Setter method.
	 * @param manual the new value in the database <code>String</code>
	 *        representation
	 */
    public void setManual(String manual);

	/**
	 * "Getter" method.
	 * @return the value
	 */
    public boolean isManual();

	/**
	 * "Getter" method.
	 * @return the value in database <code>String</code> representation
	 */
    public String getManual();

	/**
	 * Setter method.
	 * @param s the new value
	 */
    public void setStepable(boolean s);

	/**
	 * Setter method.
	 * @param stepable the new value in the database <code>String</code>
	 *        representation
	 */
    public void setStepable(String stepable);

	/**
	 * "Getter" method.
	 * @return the value
	 */
    public boolean isStepable();

	/**
	 * "Getter" method.
	 * @return the value in database <code>String</code> representation
	 */
    public String getStepable();

	/**
	 * Active getter for this operator's OpParam's.
	 * 
	 * @return the <code>Collection</code> of <code>OpParam</code>s for this operator
	 */
	public Collection getOpParams() throws M4Exception;

	/**
	 * Add an <code>OpParam</code> object to this operator's specification.
	 * @param opParam the <code>OpParam</code> to be added
	 */
	public void addOpParam(OpParam opParam) throws M4Exception;
	
	/**
	 * Remove an <code>OpParam</code> object from this operator's specification.
	 * 
	 * @param opParam the <code>OpParam</code> to be removed
	 * @return <code>true</code> iff the object was part of this <code>Operator</code>'s
	 * specification and could be removed.
	 */
	public boolean removeOpParam(OpParam opParam) throws M4Exception;

	// ***** Constraints, Conditions, Assertions *****

	public Collection getAssertions() throws M4Exception;
	
	public Collection getConditions() throws M4Exception;
	
	public Collection getConstraints() throws M4Exception;

	/** 
	 * @param assertion an <code>Assertion</code> to be added
	 */
	public void addAssertion(Assertion assertion) throws M4Exception;

	/** 
	 * @param condition a <code>Condition</code> to be added
	 */	
	public void addCondition(Condition condition) throws M4Exception;
	
	/** 
	 * @param constraint a <code>Constraint</code> to be added
	 */		
	public void addConstraint(Constraint constraint) throws M4Exception;

	/** 
	 * @param assertion an <code>Assertion</code> to be removed
	 */
	public boolean removeAssertion(Assertion assertion) throws M4Exception;
	
	/** 
	 * @param condition a <code>Condition</code> to be removed
	 */	
	public boolean removeCondition(Condition condition) throws M4Exception;
	
	/** 
	 * @param constraint a <code>Constraint</code> to be removed
	 */		
	public boolean removeConstraint(Constraint constraint) throws M4Exception;
		
	
	//methods from old interface

  /* Association methods */

  /**
   * Creates a new Assertion for this Operator.
   * @throws CreateException when an error occurs during creation of the object.
   */
  Assertion createAssertion(String type, String object1, String object2, String text)
    throws M4Exception;

  /**
   * Creates a new Condition for this Operator.
   * @throws CreateException when an error occurs during creation of the object.
   */
  Condition createCondition(String type, String object1, String object2, String text)
    throws M4Exception;

  /**
   * Creates a new Constraint for this Operator.
   * @throws CreateException when an error occurs during creation of the object.
   */
  Constraint createConstraint(String type, String object1, String object2,
    String text) throws M4Exception;

  /**
   * Creates a new OperatorParameter for this Operator.
   * @throws CreateException when an error occurs during creation of the object.
   */
  OpParam createOperatorParameter(String name, int minNrOfArgs,
    int maxNrOfArgs, String ioType, String parameterType,
    String text) throws M4Exception;


  /**
   * Returns all OperatorParameters of type INPUT.
   */
  Collection getAllInputOperatorParameters() throws M4Exception ;

  /**
   * Returns all OperatorParameters of type OUTPUT.
   */
  Collection getAllOutputOperatorParameters() throws M4Exception;

  Collection getOperatorParametersByType(String type) throws M4Exception;

  /**
   * Returns the OpParam with the given name, if it exists, and NULL otherwise.
   * 
   * @param name the name 
   * @return an OpParam or null
   * @throws M4Exception
   */
  public OpParam getOpParam(String name) throws M4Exception;

  /**
   * An operator can have parameter arrays whose values must be 
   * coordinated positionwise. This method returns all collections
   * of such arrays. That is, it returns a <code>Collection</code>
   * of <code>Collection</code>s of <code>OpParam</code>
   * objects. Each of the <code>OpParam</code> objects represents a parameter 
   * array that belongs to this operator. All parameter arrays within one of
   * the returned <code>Collection</code>s must be 
   * coordinated positionwise. If no coordinated parameter arrays exist, 
   * an empty collection is returned.
   * 
   * @return a Collection of Collections of OpParam objects
   * @throws M4Exception
   */
  public Collection getCoordinatedParameterArrays() throws M4Exception;

  /**
   * Remove the specified OperatorParameter for this Operator.
   */
  void removeOperatorParameter(String name) throws M4Exception;

  /**
   * Removes all OperatorParameters of this Operator. They are also removed from the M4 Schema.
   */
  void removeAllOperatorParameters() throws M4Exception;

  /**
   * Removes all OperatorParameters of this Operator of the specified type. They are also removed from the M4 Schema.
   */
  void removeOperatorParameterByType(String type) throws M4Exception;
}
/*
 * Historie
 * --------
 * 
 * $Log: Operator.java,v $
 * Revision 1.4  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:16  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
