/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: M4Data.java,v 1.3 2006/04/11 14:10:12 euler Exp $
 */
public interface M4Data extends M4Object {

	/**
	 * This method checks if the given name can be used as the name
	 * for an object of the given type when this M4Data object is the 
	 * container object, or if that would result in a name conflict. 
	 * For example, if this M4Data object is a Case, the given object 
	 * type might be Step. Then it would be checked if the given
	 * name can be used as the name for a new Step in this Case.
	 * A unique name for an object of the given type in the context 
	 * given by this M4Data object is returned, which is either equal 
	 * to the given name, or to the given name plus a number suffix.
	 * 
	 * @param name The name to be checked.
	 * @param typeOfNamedObject The type of object for which the name should be valid.
	 * @return A valid name
	 * @throws M4Exception
	 */
	public String getValidName(String name, Class typeOfNamedObject) throws M4Exception;
	
	/**
	 * Check if this object reflects the state of the
	 * database or if the object needs to be written
	 * back to the database at the next store command.
	 * 
	 * @return TRUE if the object needs to be stored
	 *         FALSE if it reflects the database.
	 */
	public boolean isDirty();

	/**
	 * The method to delete all references of an <code>M4Data</code>
	 * object and to remove the tuple(s) representing the object
	 * from the M4 database.
	 * 
	 * After calling the method <code>removeAllM4References()</code>
	 * this method sets an internal flag indicating that it needs to be
	 * deleted at the next store command. This includes setting the
	 * dirty flag.
	 */
	public void deleteSoon() throws M4Exception;

	/**
	 * Indicates if this object's representation will
	 * be deleted in the database at the next update
	 * operation.
	 * 
	 * @return TRUE if the object needs to be deleted
	 *         FALSE otherwise
	 */
	public boolean isWaitingForDelete();
	
	/**
	 * Sets documentation for this object.
	 */
	public void setDocumentation(String text) throws M4Exception;

	/**
	 * Returns documentation for this object.
	 */
	public String getDocumentation() throws M4Exception;
}
/*
 * Historie
 * --------
 * 
 * $Log: M4Data.java,v $
 * Revision 1.3  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:23  hakenjos
 * Initial version!
 *
 */
