/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Daniel Hakenjos, Timm Euler
 * @version $Id: Docu.java,v 1.3 2006/04/11 14:10:13 euler Exp $
 */
public interface Docu extends M4Data{

	//methods fom core

	/**
	 * Returns the M4Object that this documentation entry belongs to.
	 * 
	 * @return M4Object
	 */
	public M4Object getM4Object();

	/**
	 * Returns the actual documentation entry (the description String).
	 * 
	 * @return String
	 */
	public String getText();
	
	/**
	 * Set the connection to the M4 object that this
	 * documentation object is associated with.
	 */
	public void setM4Object(M4Data newM4Object) throws M4Exception;

	/**
	 * Sets the text (the description String for the M4 Object 
	 * that this Documentation object belongs to).
	 * 
	 * @param newText The new text to set
	 */
	public void setText(String newText);
	
	/**
	 * Returns the id of the M4 object associated with
	 * this documentation object.
	 * 
	 * @return long
	 */
	public long getObjectId();

	/**
	 * Returns the type of the M4 object associated with
	 * this documentation object.
	 * 
	 * @return String
	 */
	public String getObjectType();

	/**
	 * Sets the id of the M4 object associated with
	 * this documentation object.
	 * 
	 * @param id The id to set
	 */
	public void setObjectId(long id) throws M4Exception;

	/**
	 * Sets the the type of the M4 object associated with
	 * this documentation object.
	 * 
	 * @param type The class of the M4 object.
	 */
	public void setObjectType(String type) throws M4Exception;		
}
/*
 * Historie
 * --------
 * 
 * $Log: Docu.java,v $
 * Revision 1.3  2006/04/11 14:10:13  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
