/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.UserError;
import edu.udo.cs.miningmart.operator.ExecutableOperator;

/**
 * @author Daniel Hakenjos, Timm Euler
 * @version $Id: Condition.java,v 1.5 2006/04/11 14:10:12 euler Exp $
 */
public interface Condition extends M4Data {

	//methods from core

	/**
	 * Gets the myObj1.
	 * @return Returns a String
	 */
	public String getObj1();

	/**
	 * Gets the myObj2.
	 * @return Returns a String
	 */
	public String getObj2();

	/**
	 * Gets the Operator
	 * @return Returns an <code>Operator</code>
	 */
	public Operator getTheOperator();

	/**
	 * Gets the myType.
	 * @return Returns a String
	 */
	public String getType();

	/**
	 * Sets the myObj1.
	 * @param myObj1 The myObj1 to set
	 */
	public void setObj1(String myObj1);

	/**
	 * Sets the myObj2.
	 * @param myObj2 The myObj2 to set
	 */
	public void setObj2(String myObj2);

	/**
	 * Sets the Operator.
	 * @param operator The <code>Operator</code> to set
	 */
	public void setTheOperator(Operator operator) throws M4Exception;

	/**
	 * Sets the myType.
	 * @param myType The myType to set
	 */
	public void setType(String myType);

	/**
	 * Checks the <code>Condition</code> for the specified <code>ExceutableOperator</code>.
	 * Currently this method directly throws a <code>UserError</code> exception to be propagated
	 * to the GUI if the <code>Condition</code> is violated.
	 *  
	 * @param op
	 * @throws UserError
	 * @throws M4Exception
	 */
	public void check(ExecutableOperator op) throws UserError, M4CompilerError;
	//methods from old interface

	// TE: probably not used	
	//public String getShortDescription();
	//public void setShortDescription(String shortDescription);
	//public String getSql();
	//public void setSql(String sql);

}
/*
 * Historie
 * --------
 * 
 * $Log: Condition.java,v $
 * Revision 1.5  2006/04/11 14:10:12  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/23 11:13:46  euler
 * Improved exception handling.
 *
 * Revision 1.2  2006/03/19 21:16:51  scholz
 * conditions are now checked before executing an operator
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
