/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.m4;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.operator.ExecutableOperator;

/**
 * @author Timm Euler, Daniel Hakenjos
 * @version $Id: Assertion.java,v 1.6 2006/04/11 14:10:13 euler Exp $
 */
public interface Assertion extends M4Data {

	/*
	 * Public constants used for the different types of Assertions. 
	 */
	public static final String TYPE_PROJECTION         = "PROJ";
	public static final String TYPE_SUBCONCEPT         = "SUBSET";
	public static final String TYPE_GREATER_OR_EQUAL   = "GE";
	public static final String TYPE_LESS_OR_EQUAL      = "LE";
	public static final String TYPE_LESS_THAN          = "LT";
	public static final String TYPE_NO_NULLS           = "NOT_NULL";
	public static final String TYPE_GREATER_THAN       = "GT";
	public static final String TYPE_ORDERED            = "ORDERED";
	public static final String TYPE_KNOWN_TYPE         = "TYPE";
	public static final String TYPE_UNIQUE             = "UNIQUE";
	// an assertion stating that a 1:n relationship exists between obj1 and obj2:
	public static final String TYPE_REL_ONE_TO_MANY    = "REL_1_N";
	// an assertion stating that a n:1 relationship exists between obj2 and obj1:
	public static final String TYPE_REL_MANY_TO_ONE    = "REL_N_1";
	// an assertion stating that the keys of the "many-side" are given by 
	// the attributes given in obj1:
	public static final String TYPE_REL_MANY_KEY       = "REL_N_K";
	// an assertion stating that the keys of the "one-side" are given by 
	// the attributes given in obj1:
	public static final String TYPE_REL_ONE_KEY        = "REL_1_K";
	
	//Methods from core

	/**
	 * Get the myObj1.
	 */
	public String getObj1();

	/**
	 * Get the myObj2.
	 */
	public String getObj2();

	/**
	 * Get the Operator
	 */
	public Operator getTheOperator();

	/**
	 * Set the myObj1.
	 */
	public void setObj1(String myObj1);

	/**
	 * Set the myObj2.
	 */
	public void setObj2(String myObj2);

	/**
	 * Set the Operator.
	 */
	public void setTheOperator(Operator operator) throws M4Exception;
	
	//methods from old interface

	/* Attribute methods */

	public String getAssertionType();

	public void setAssertionType(String assertionType);
	
	/** This method remembers the operator assertions for subsequent operations. */
	public void writeAssertion(ExecutableOperator op) throws M4CompilerError;
}
/*
 * Historie
 * --------
 * 
 * $Log: Assertion.java,v $
 * Revision 1.6  2006/04/11 14:10:13  euler
 * Updated license text.
 *
 * Revision 1.5  2006/04/06 16:31:12  euler
 * Prepended license remark.
 *
 * Revision 1.4  2006/03/23 11:13:46  euler
 * Improved exception handling.
 *
 * Revision 1.3  2006/03/20 16:44:21  euler
 * Bugfixes
 *
 * Revision 1.2  2006/03/20 14:02:24  scholz
 * added assertion handling
 *
 * Revision 1.1  2006/01/03 09:54:24  hakenjos
 * Initial version!
 *
 */
