/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.util;

import java.util.Iterator;
import java.util.LinkedList;

/**
 *A class for holding the information about the recent files.
 * @author Daniel Hakenjos
 * @version $Id: RecentFiles.java,v 1.3 2006/04/11 14:10:18 euler Exp $
 */
public class RecentFiles {

	private LinkedList files;

	private int maxsize;


	/**
	 * Constructor for RecentFiles.
         * @param max_size the maximum size
	 */
	public RecentFiles(int max_size) {
		files=new LinkedList();
		this.maxsize=max_size;
	}

        /**
         *Gets the maximum size.
         */
	public int getMaxSize(){
		return maxsize;
	}

        /**
         * Gets the real size.
         */
	public int getSize(){
		return files.size();
	}

        /**
         *Gets the file at the specified index.
         */
	public String getFile(int index){
		return (String) files.get(index);
	}

        /**
         * Sets the specified recent file.
         * The file is then on position 1.
         */
	public void setRecentFile(String file){
		setRecentFile(file,1);
	}

        /**
         * Sets the specified recent file at this position.
         */
	public void setRecentFile(String file, int position){
		if (position>files.size()+1){
			position=files.size()+1;
		}
		int index=position-1;
		if (!(index<maxsize))
			return;
		
		if (files.contains(file)){
			files.remove(file);
			files.add(index,file);
			return;
		}

		files.add(index,file);		

		if (files.size()>maxsize){
			files.removeLast();
		}
		
	}

        /**
         * Removes the specified recent file.
         */
	public void removeRecentFile(String file){
		files.remove(file);
	}
	
	public String toString(){
		String back=new String("");
		Iterator iter=files.iterator();

		int i=0;
		while (iter.hasNext()){
			if (i>0)
				back+=";";
			back+=((String) iter.next()); 			
			i++;
		}
		return back;
	}
}
/*
$Log: RecentFiles.java,v $
Revision 1.3  2006/04/11 14:10:18  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:17  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:33  hakenjos
Initial version!

*/
