/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.util;

import java.util.Vector;

import javax.swing.JOptionPane;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.DeleteCaseDialog;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A class for trashing a case.
 * @author Daniel Hakenjos
 * @version $Id: CaseTrasher.java,v 1.4 2006/04/11 14:10:18 euler Exp $
 */
public class CaseTrasher {

	private int retVal;
	private Case m4case = null;
	private boolean caseWasOpen;

	private MiningMartApplication application;

        
	public CaseTrasher(MiningMartApplication application) {
		this.application = application;
	}

        /**
         *Inits this <code>CaseTrasher</code>.
         */
	public void init() {
		this.retVal = JOptionPane.YES_OPTION;

		if (application.getModel() != null && M4Interface.getCurrentCase() != null) {

			this.m4case = M4Interface.getCurrentCase();
			this.caseWasOpen = true;
		} else {
			this.caseWasOpen = false;
			Vector m4Cases = null;
			DeleteCaseDialog dialog = new DeleteCaseDialog(application);

			String casename = null;

			if (dialog.getExitAction() == DeleteCaseDialog.DELETE) {
				retVal = JOptionPane.YES_OPTION;
				casename = dialog.getSelectedCase();
			} else {
				retVal = JOptionPane.CANCEL_OPTION;
				return;
			}

			try {
				this.m4case =
					MiningMartApplication.m4Interface.findCaseForUpdate(
						casename,
						true);
			} catch (Exception e) {
				JOptionPane.showMessageDialog(
					application,
					Resource.getString("ERROR_CANNOT_DELETE_CASE"),
					Resource.getString("DIALOG_ERROR_TITLE"),
					JOptionPane.ERROR_MESSAGE);
				retVal = JOptionPane.CANCEL_OPTION;
			}
		}
	}

	/**
	 * Deletes a selected Case.
	 * @return '0' if case was deleted, '-1' otherwise
	 */
	public int deleteCase() {
		if (this.m4case == null || retVal != JOptionPane.YES_OPTION) {
			return -1;
		}

		final Case caseToDelete = this.m4case;
		this.m4case = null;

		this.retVal =
			JOptionPane.showOptionDialog(
				application,
				Resource.getString("DELETE_CASE_MSG1")+"\n"
					+ caseToDelete.getName()
					+ "!\n"
					+ Resource.getString("DELETE_CASE_MSG2"),
				Resource.getString("DELETE_CASE_TITLE"),
				JOptionPane.YES_NO_OPTION,
				JOptionPane.QUESTION_MESSAGE,
				null,
				null,
				null);

		if (retVal != JOptionPane.YES_OPTION) {

			if (this.caseWasOpen == false) {
				MiningMartApplication.m4Interface.releaseCase(caseToDelete.getName());
			}
			return -1;
		} else {
//			M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,"Deleting the case : "+ caseToDelete.getName());

			if (this.caseWasOpen) {
				application.promptClose();
			} else {
				MiningMartApplication.m4Interface.releaseCase(caseToDelete.getName());
			}
			
			try {
				caseToDelete.deleteSoon();
				caseToDelete.store();
			} catch (M4Exception e) {
				M4Interface.print.doPrint(Print.ERROR,Resource.getString("ERROR_CANNOT_DELETE_CASE"),e);

				JOptionPane.showMessageDialog(
					application,
					Resource.getString("ERROR_CANNOT_DELETE_CASE")+"\n"+
					caseToDelete.getName()+"\n"+e.getMessage(),
					Resource.getString("DIALOG_ERROR_TITLE"),
					JOptionPane.ERROR_MESSAGE);
				return -1;
			}

			M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("CASE_DELETED"));
			if (M4Interface.getCurrentCase().equals(caseToDelete)) {
				M4Interface.removeCurrentCase();
			}
			return 0;
		}
	}

}
/*
 * Historie
 * --------
 *
 * $Log: CaseTrasher.java,v $
 * Revision 1.4  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/01/27 17:27:17  euler
 * Bugfix
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */
