/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.XMLFileFilter;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * This class is used to export a case.
 * @author Martin Scholz, Daniel Hakenjos
 * @version $Id: CaseExporter.java,v 1.3 2006/04/11 14:10:18 euler Exp $
 */
public class CaseExporter { 

	private MiningMartApplication app;

	private String filename;
	private Writer exportWriter;
	private Case casetoexport;

	private int returnVal = JOptionPane.YES_OPTION;

	private boolean withColumns = false;
	private boolean noFile = true;

	public CaseExporter(MiningMartApplication parent, Case caseToExport) {
		this.app = parent;
		this.casetoexport = caseToExport;
		init();
	}

	/**
	 * Selects the path and filename and opens the output stream
	 */
	public void init() {
		JFileChooser chooser = new JFileChooser(app.getWorkingDir());
		chooser.setFileFilter(new XMLFileFilter());
		returnVal = chooser.showSaveDialog(app);
		File file = chooser.getSelectedFile();
		if (file == null) {
			noFile = true;
			return;
		}

		noFile = false;
		filename = file.getPath();
		if (!filename.endsWith(".xml")){
			if (filename.lastIndexOf(".")!=-1)
				filename=filename.substring(0,filename.lastIndexOf("."));

			filename=filename+".xml";
			file=new File(filename);
		}

		if (file.exists()) {
			int ret =
				JOptionPane.showConfirmDialog(
					app,
					Resource.getString("QUEST_OVERWRITE")+"\n" + file.getName() ,
					Resource.getString("DIALOG_TITLE_FILE_EXISTS"),
					JOptionPane.YES_NO_OPTION,
					JOptionPane.QUESTION_MESSAGE
					);
			if (ret == JOptionPane.NO_OPTION) {
				noFile = true;
				return;
			}
			app.setWorkingDir(file.getParent());			
		}

		try {
			FileWriter f = new FileWriter(filename);
			this.exportWriter = new BufferedWriter(f);
		} catch (FileNotFoundException fnfe) {
			M4Interface.print.doPrint(Print.ERROR,fnfe.getMessage(),fnfe);
			returnVal = JOptionPane.CANCEL_OPTION;
		} catch (IOException ioe) {
			M4Interface.print.doPrint(Print.ERROR,ioe.getMessage(),ioe);
			returnVal = JOptionPane.CANCEL_OPTION;
		}
	}

	public void exportCase() {
		if (noFile)
			return;

		try {
			edu.udo.cs.miningmart.m4.utils.M4Xml.exportCase(
				(edu.udo.cs.miningmart.m4.core.Case) casetoexport,
				this.exportWriter);
		} catch (IOException ioe) {
			M4Interface.print.doPrint(Print.ERROR,Resource.getString("ERROR_EXPORT_CASE1")+" "+Resource.getString("ERROR_EXPORT_CASE2")+" " +Resource.getString("ERROR_EXPORT_CASE3"),ioe);
			JOptionPane.showMessageDialog(
				app,
				Resource.getString("ERROR_EXPORT_CASE2")+" "+Resource.getString("ERROR_EXPORT_CASE3"),
				Resource.getString("ERROR_EXPORT_CASE1"),
				JOptionPane.ERROR_MESSAGE);
			ioe.printStackTrace();
			returnVal = JOptionPane.CANCEL_OPTION;
			return;
		}

		if (returnVal != JOptionPane.CANCEL_OPTION) {
			M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,
														Resource.getString("CASE_EXPORTED1") +"\""+casetoexport.getName()+
														"\""+ Resource.getString("CASE_EXPORTED2")+filename);
			JOptionPane.showMessageDialog(
				app,
				Resource.getString("CASE_EXPORTED1") +casetoexport.getName()+ "!",
				Resource.getString("DIALOG_INFO_TITLE"),
				JOptionPane.INFORMATION_MESSAGE);
		}
	}
	
}
/*
 * Historie
 * --------
 *
 * $Log: CaseExporter.java,v $
 * Revision 1.3  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:34  hakenjos
 * Initial version!
 *
 */
