/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.BorderLayout;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 *An editor and renderer for single-selection of a <code>Value</code>.
 * @author Daniel Hakenjos
 * @version $Id: SingleValueEditor.java,v 1.3 2006/04/11 14:10:13 euler Exp $
 */
public class SingleValueEditor extends ParameterEditor{

	private JTextField field;
	
	/**
	 *Constructs a new <code> SingleValueEditor</code>.
	 */
	public SingleValueEditor(MiningMartApplication app, Step step, OpParam opParam) {
		super(app,step,opParam);
		editorComponent=new JPanel(new BorderLayout());
		field=new JTextField();
		((JPanel) editorComponent).add(field,BorderLayout.CENTER);
		field.setHorizontalAlignment(SwingConstants.LEFT);

		init();
		setEditable();
	}
	
	public void init(){
		Value value=null;
		String text=null;
		field.setText("");
		Collection coll=getParameterCollection();
		if (coll!=null){
			Iterator iter=coll.iterator();
			if (iter.hasNext()){
				value=(Value) iter.next();
			}
		}
		
		if (value!=null){
			text="";
			if (value.getValue()!=null)
				text=value.getValue();
			field.setText(text);
			try {
				field.setToolTipText(value.getDocumentation());
			} catch (M4Exception error) {
				error.printStackTrace();
			}
		}
	}
	
	/**
	 * @see javax.swing.CellEditor#stopCellEditing()
	 */
	public boolean stopCellEditing() {
		String text=field.getText();

		Value value=null;
		Collection coll=getParameterCollection();
		if (coll!=null){
			Iterator iter=coll.iterator();
			if (iter.hasNext()){
				value=(Value) iter.next();
			}
		}
		
		try{
			if (value==null){
				value=opParam.createValueObject();
			}

			String valuestr=value.getValue();

			if (valuestr==null)
				valuestr="";

			if (!valuestr.equals(field.getText())){
				this.fireStateChanged();
			}
			value.setValue(text);
			value.setType(opParam.getConceptualDatatypeForValue());
			
			LinkedList list=new LinkedList();
			if (value.getValue().length()>0){
				list.add(value);
			}
			
			setParameterCollection(list);
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}

		return super.stopCellEditing();
	}
	
	


	/**
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#setLoopNumber(int)
	 */
	public void setLoopNumber(int loopnumber) {
		super.setLoopNumber(loopnumber);
/*		boolean loopable=true;
		try{
			loopable=opParam.isLoopable();
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			loopable=true;
		}
		
		if ((loopnumber>1)&&(!loopable)){
			field.setEditable(false);
		}else{
			field.setEditable(true);
		}*/
	}
	
	

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#existsOutput()
	 */
	public boolean existsOutput() {
			//dies kann kein output sein!
			return false;
	}
	
	

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#setEditable()
	 */
	public void setEditable() {
		super.setEditable();
		field.setEditable(this.editable);
	}

}
/*
$Log: SingleValueEditor.java,v $
Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:13  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:15  hakenjos
Initial version!

*/
