/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.ParameterObject;
import edu.udo.cs.miningmart.m4.Step;

/**
 *An editor and renderer for single-selection.
 * @author Daniel Hakenjos
 * @version $Id: SingleSelectEditor.java,v 1.3 2006/04/11 14:10:13 euler Exp $
 */
public class SingleSelectEditor extends SelectEditor implements ActionListener {

	protected JTextField textfield;
	
	protected ParameterObject paramobject;
	
	/**
	 *Constructs a new <code>SingleSelectEditor</code>.
	 */
	public SingleSelectEditor(MiningMartApplication app,
								Step step,
								OpParam opParam) {
		super(app, step, opParam);

		initComponents();
		init();
		setEditable();
	}

	private void initComponents() {
		JPanel panel = new JPanel(new BorderLayout());
		this.editorComponent = panel;
		setClickCountToStart(1);

		textfield = new JTextField("");
		textfield.setEditable(false);
		textfield.setBackground(Color.WHITE);
		textfield.setForeground(Color.BLACK);

		panel.add(textfield, BorderLayout.CENTER);

		button = new JButton("...");
		button.addActionListener(this);
		panel.add(button, BorderLayout.EAST);

	}

	public void init() {
		paramobject=null;
		textfield.setText("");
		Collection coll = getParameterCollection();
		if (coll != null) {
			Iterator iter = coll.iterator();
			if (iter.hasNext()) {
				if (opParam.isInput()){
					this.paramobject = (ParameterObject) iter.next();
				}else{
				}
			}
		}
	}

	/**
     * For your own selection you must overwrite this method.
     * Especially to construct the list.
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		String[] data = new String[] { "x", "y", "z", "u", "v", "w", "s", "d" };
		SingleSelectDialog dialog =
			new SingleSelectDialog(app, "title", "selecttitle", data, true);
		if (dialog.getExitAction() == SingleSelectDialog.OK) {
			textfield.setText(dialog.getSelectedDataItem());
		}
	}

	/**
	 *Gets the selected value.
	 */
	public String getSelectedValue() {
		return textfield.getText();
	}

	/**
	 * Gets the <code>ParameterObject</code>.
	 */
	public ParameterObject getParameterObject() {
		return paramobject;
	}

	/**
	 * Gets the <code>ParameterObject</code> in a <code>Collection</code>.
	 */
	public Collection getParameterObjects() {
		LinkedList list = new LinkedList();
		list.add(paramobject);
		return list;
	}
	
	
	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#setEditable()
	 */
	public void setEditable() {
		super.setEditable();
		textfield.setEditable(this.editable);
		button.setEnabled(this.editable);
	}

}
/*
$Log: SingleSelectEditor.java,v $
Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:15  hakenjos
Initial version!

*/
