/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;


/**
 * A Dialog for selecting one item of a list.
 * @author Daniel Hakenjos
 * @version $Id: SingleSelectDialog.java,v 1.3 2006/04/11 14:10:13 euler Exp $
 */
public class SingleSelectDialog extends JDialog	implements ActionListener, ListSelectionListener{

	public static final int CANCEL = 0;
	public static final int OK = 1;

	private JList datalist;
	private JButton cancel, ok;
	private int exitAction;
	
	private String[] data;
	private boolean sortdata;

	private String selecttitle;

	/**
	 * Constructor for ListSelectDialog.
	 */
	public SingleSelectDialog(MiningMartApplication parent, String title,String selecttitle, String[] data, boolean sortdata) {
		super(parent, title, true);

		this.exitAction = CANCEL;
		this.data=data;
		this.sortdata=sortdata;
		this.selecttitle=selecttitle;
		initComponents();
		this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

		this.pack();

		setSize(300, 300);

		Dimension size = this.getSize();

		this.setLocation(
			(Toolkit.getDefaultToolkit().getScreenSize().width - size.width)
				/ 2,
			(Toolkit.getDefaultToolkit().getScreenSize().height - size.height)
				/ 2);
		this.setVisible(true);
	}

	/**
	 * Implementation of selection-Sort.
	 * 
	 */
	private String[] selectionSort(String[] data) {
		for (int i = 1; i < data.length - 1; i++) {
			// Erstes minimales Element in (a[i],...,a[n-1]) finden ...
			int min = i; // Position des aktuellen minimalen Elements
			for (int j = i + 1; j < data.length; j++)
				if (data[j].compareTo(data[min]) < 0)
					min = j;
			// ... und mit a[i] vertauschen:
			swap(data, min, i);
		}
		return data;
	}

	/** Hilfsmethode zur Vertauschung der Array-Elemente a[i] und a[j]. 
	  * Wir setzen 0 &le;= i, j &le; a.length voraus. 
	  */
	private void swap(Comparable[] a, int i, int j) {
		Comparable tmp = a[i];
		a[i] = a[j];
		a[j] = tmp;
	}

	/**
	 * Init the components of the dialog.
	 */
	public void initComponents() {

		JPanel top_panel = new JPanel();
		top_panel.setLayout(new BorderLayout(5, 5));

		datalist = new JList();
		datalist.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		datalist.setLayoutOrientation(JList.VERTICAL);
		datalist.setVisibleRowCount(-1);
		datalist.addListSelectionListener(this);

		if (sortdata)
			data = selectionSort(data);

		datalist.setListData(data);

		JScrollPane scrollpane = new JScrollPane(datalist);

		JPanel mid_panel = new JPanel();
		mid_panel.setLayout(new BorderLayout());

		mid_panel.add(scrollpane, BorderLayout.CENTER);

		top_panel.add(mid_panel, BorderLayout.CENTER);

		cancel = new JButton(Resource.getString("CANCEL"));
		ok = new JButton(Resource.getString("OK"));
		ok.setEnabled(false);

		cancel.addActionListener(this);
		ok.addActionListener(this);

		JPanel bottom = new JPanel();
		bottom.setLayout(new BoxLayout(bottom, BoxLayout.X_AXIS));
		bottom.add(Box.createHorizontalGlue());
		bottom.add(ok);
		bottom.add(Box.createRigidArea(new Dimension(10, 0)));
		bottom.add(cancel);

		top_panel.add(bottom, BorderLayout.SOUTH);

		JLabel label = new JLabel(selecttitle);

		top_panel.add(label, BorderLayout.NORTH);

		top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		this.getContentPane().add(top_panel);
	}

	/**
	 * Called if one of the buttns was pressed.
	 */
	public void actionPerformed(ActionEvent e) {
		String cmd = e.getActionCommand();

		if (cmd.equals(Resource.getString("CANCEL"))) {
			exitAction = CANCEL;
			this.dispose();
		}
		if (cmd.equals(Resource.getString("OK"))) {
			exitAction = OK;
			this.dispose();
		}
	}

	/**
	 * If the user selects something in the list then the ok-button is enabled.
	 */
	public void valueChanged(ListSelectionEvent e) {
		if (!datalist.isSelectionEmpty()) {
			ok.setEnabled(true);
		}
	}

        /**
         *Gets the action when the dialog was exited.
         */
	public int getExitAction() {
		return exitAction;
	}

        /**
         *Gets the selected data-item.
         */
	public String getSelectedDataItem() {
		if (exitAction == OK)
			return (String) datalist.getSelectedValue();
		return null;
	}


}
/*
$Log: SingleSelectDialog.java,v $
Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:13  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:14  hakenjos
Initial version!

*/
