/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import javax.swing.JComboBox;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * An editor and renderer for single-selecting of a <code>Value</code> from a fixed list.
 * @author Daniel Hakenjos
 * @version $Id: SingleOneOfValueEditor.java,v 1.3 2006/04/11 14:10:13 euler Exp $
 */
public class SingleOneOfValueEditor extends ParameterEditor implements ItemListener{
	
	private Collection oneOfList;
	
	private boolean propagate;
	
	private int itemindex;

    /**
     *Constructs a new <code>SingleOneOfValueEditor</code>.
     */
	public SingleOneOfValueEditor(MiningMartApplication app, Step step, OpParam opParam, Collection oneoflist){
        super(app,step,opParam);
		this.oneOfList=oneoflist;
		this.propagate=true;
		
		editorComponent=new JComboBox(oneoflist.toArray());
		((JComboBox) editorComponent).addItemListener(this);
        editorComponent.setForeground(Color.BLACK);
        editorComponent.setBackground(Color.WHITE);
        this.setClickCountToStart(1);
        
		init();
		setEditable();
    }
    
    public void init(){
    	Value value=null;
    	String text=null;

    	if (text==null)
			text=(String) oneOfList.toArray()[0];
		
		Collection coll=getParameterCollection();
		if (coll!=null){
			Iterator iter=coll.iterator();
			if (iter.hasNext()){
				value=(Value) iter.next();
			}
		}

		if (value!=null){
			if (value.getValue()!=null)
				text=value.getValue();

	        try{
		        ((JComboBox) editorComponent).setToolTipText(value.getDocumentation());
	        }catch(M4Exception error){ 
				M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
	        }
		}
		try{
			value=opParam.createValueObject();
			value.setValue(text);
			
			LinkedList list=new LinkedList();
			list.add(value);
			
			setParameterCollection(list);
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
        ((JComboBox) editorComponent).setSelectedItem(text);
        
    }
    
	/**
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#setLoopNumber(int)
	 */
	public void setLoopNumber(int loopnumber) {
		super.setLoopNumber(loopnumber);
/*		boolean loopable=true;
		try{
			loopable=opParam.isLoopable();
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			loopable=true;
		}
		
		if ((loopnumber>1)&&(!loopable)){
			((JComboBox) editorComponent).setEditable(false);
		}else{
			((JComboBox) editorComponent).setEditable(true);
		}*/
	}

	
	/**
	 * @see java.awt.event.ItemListener#itemStateChanged(ItemEvent)
	 */
	public void itemStateChanged(ItemEvent e) {
		try{
//			System.out.println("itemstatechanged");

			Value value=null;
			String text=(String) ((JComboBox) editorComponent).getSelectedItem();
			Collection coll=getParameterCollection();
			if (coll!=null){
				Iterator iter=coll.iterator();
				if (iter.hasNext()){
					value=(Value) iter.next();
				}
			}


			if (value==null){
				value=opParam.createValueObject();
			}
			
			String valuestr=value.getValue();
			if (valuestr==null)
				valuestr=(String) oneOfList.toArray()[0];
			if (!valuestr.equals(text)){
				this.fireStateChanged();
			}
			value.setValue(text);
			
			LinkedList list=new LinkedList();
			list.add(value);
			
//			System.out.println("value: "+value.getValue());
			setParameterCollection(list);
			
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}

		stopCellEditing();
		
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#existsOutput()
	 */
	public boolean existsOutput() {
		//dies kann doch gar kein output sein

		return false;
	}
	
	


	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#setEditable()
	 */
	public void setEditable() {
		super.setEditable();
		((JComboBox) editorComponent).setEnabled(this.editable);
	}

}
/*
$Log: SingleOneOfValueEditor.java,v $
Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:15  hakenjos
Initial version!

*/
