/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 *An editor and renderer for single-selection of a <code>BaseAttribute</code>.
 * @author Daniel Hakenjos
 * @version $Id: SingleBaseAttributeEditor.java,v 1.3 2006/04/11 14:10:13 euler Exp $
 */
public class SingleBaseAttributeEditor extends SingleSelectEditor {
	
	private StepParameterTable table;

	private Vector features;
    /**
     *Constructs a new <code>SingleBaseAttributeEditor</code>.
     */
	public SingleBaseAttributeEditor(MiningMartApplication app,StepParameterTable table, OpParam opParam){
		super(app,table.getTheStep(),opParam);
		this.table=table;
	}
	
	public void init(){
		super.init();


		if (opParam.isInput()){
			if((paramobject!=null)&&(paramobject instanceof BaseAttribute)){
				try{
					String name=new String("");
					if (((BaseAttribute) paramobject).getConcept()!=null){
						name=((BaseAttribute) paramobject).getConcept().getName();
					}
					this.textfield.setText(((BaseAttribute) paramobject).getName()+" ["+name+"]");
				}catch(M4Exception error){
					M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
				}
			}
		}else{
			Collection coll=getFeatureCollection();
			Iterator iter=coll.iterator();
			if (iter.hasNext()){
				BaseAttribute baseatt=(BaseAttribute) iter.next();
				try{
					String name=new String("");
					if (baseatt.getConcept()!=null){
						name=baseatt.getConcept().getName();
					}
					this.textfield.setText((baseatt).getName()+" ["+name+"]");
				}catch(M4Exception error){
					M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
				}
//				this.textfield.setText((String) iter.next());
			}
		}

	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try{
			Collection conceptparams=step.getPossibleConceptsForParam(opParam);
			String[] data=new String[conceptparams.size()];

			Iterator iter=conceptparams.iterator();
			int d=0;
			while (iter.hasNext()){
				data[d]=(String) iter.next();
				d++;
			}

			Collection concepts=new LinkedList();			
			for (int i=0;i<data.length;i++){
				concepts.addAll(table.getConceptEditorValues(data[i]));
			}


			Collection battribs=new LinkedList();
			iter=concepts.iterator();
			Concept concept;
			while (iter.hasNext()){
				concept=M4Interface.getCurrentCase().getConcept((String) iter.next());
				if (concept!=null){
					Collection c=concept.getAllBaseAttributes();
					Iterator iter2=c.iterator();
					BaseAttribute ba;					
					while (iter2.hasNext()){
						ba=(BaseAttribute) iter2.next();
						if (step.isVisible(ba)){
							battribs.add(ba);
						}
					}
				}
			}

			data=new String[battribs.size()+1];
			data[0]=Resource.getString("STEPSETTINGS_NONE_SELECTION");
			
			iter=battribs.iterator();
			int c=1;
			BaseAttribute baseatt;
			String name;
			while(iter.hasNext()){
				baseatt=(BaseAttribute) iter.next();
				name=new String("");
				if (baseatt.getConcept()!=null){
					name=baseatt.getConcept().getName();
				}
				data[c]=baseatt.getName()+" ["+name+"]";
				c++;
			}
			
			SingleSelectDialog dialog=new SingleSelectDialog(app,Resource.getString("STEPSETTINGS_TITLE_BASEATTRIBUTE"),Resource.getString("STEPSETTINGS_TITLE_SELECT_BASEATTRIBUTE"),data, true);
			if (dialog.getExitAction()==SingleSelectDialog.OK){
				String selected=dialog.getSelectedDataItem();
				if (selected.equals(data[0])){
					selected="";
				}
				textfield.setText(selected);
				
				iter=battribs.iterator();
				BaseAttribute selectedBA=null;
				boolean found=false;
				while ((iter.hasNext())&&(!found)){
					selectedBA=(BaseAttribute) iter.next();
					name=new String("");
					if (selectedBA.getConcept()!=null){
						name=selectedBA.getConcept().getName();
					}
					if ((selectedBA.getName()+" ["+name+"]").equals(selected)){
						found=true;
					}
				}
				LinkedList list=new LinkedList();
				if (found){
					list.add(selectedBA);
					this.paramobject=selectedBA;
				}
				setParameterCollection(list);
				this.fireStateChanged();
			}
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
	}
	
	private void initFeatures(){
		features=new Vector();
		numberofloops=step.getLoopCount();
		if (numberofloops==0){
			numberofloops=1;
		}

		try{
			Collection coll;
			for(int i=0;i<numberofloops;i++){
				if (opParam.isCoordinated()){
					//coordinierte Parameter so auslesen
					coll=step.getParameter(opParam,0);					
					if (coll==null)	coll=new LinkedList();
					features.add(coll);
				}else if ((opParam.isLoopable())&&(numberofloops==1)){
					//opParam ist loopable, mechanismus wird im step nicht genutzt
					coll=step.getParameter(opParam,0);					
					if (coll==null)	coll=new LinkedList();
					features.add(coll);
					
				}else if ((opParam.isLoopable())&&(numberofloops>1)){
					//opParam ist loopable, mechanismus wird im step genutzt
					//also auslesen von 1...numberofloops
					coll=step.getParameter(opParam,i+1);					
					if (coll==null)	coll=new LinkedList();
					features.add(coll);
					
				}else{
					coll=step.getParameter(opParam,0);					
					if (coll==null)	coll=new LinkedList();
					features.add(coll);
				}
			}
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#setParameterCollection(java.util.Collection, int)
	 */
	public void setParameterCollection(Collection collection, int loopnumber) {
		super.setParameterCollection(collection, loopnumber);
		boolean loopable=true;
		try{
			loopable=opParam.isLoopable();
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			loopable=true;
		}

		if (features==null){
			initFeatures();
		}

		if (loopable){
			features.set(loopnumber-1, collection);
		}else{
			for(int i=0;i<paramcollections.size();i++){
				features.set(i, collection);
			}
		}
	}

	/**
	 * Gets the <code>Collection</code> of the Parameter for the specified loopnumber.
	 */
	private Collection getFeatureCollection(int loopnumber){
		boolean loopable=true;
		try{
			loopable=opParam.isLoopable();
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			loopable=true;
		}
		if (features==null){
			initFeatures();
		}
		if (loopable){		
			return (Collection) features.get(loopnumber-1);
		}else{
			return (Collection) features.get(0);
		}
	}
	
	/**
	 * Gets the <code>Collection</code> for the current loopnumber.
	 */
	private Collection getFeatureCollection(){
		return getFeatureCollection(loopnumber);
	}
	
	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#makeOutput(boolean, boolean, boolean, boolean)
	 */
	public void makeOutput(boolean inputchanged,boolean outputchanged,boolean loopcountlower,	boolean loopcounthigher)	throws M4Exception {
		super.makeOutput(inputchanged,outputchanged,loopcountlower,loopcounthigher);
		initFeatures();
	}
	
	
	
	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#existsOutput()
	 */
	public boolean existsOutput() {
		if (opParam.isInput())
			return false;

		Collection coll;
		Collection actual;
		for(int loop=1;loop<=numberofloops;loop++){
			coll=(Collection) this.oldparamcollections.get(loop-1);
			actual=(Collection) this.paramcollections.get(loop-1);
			if (coll==null){
				return false;
			}
			if (coll.isEmpty()){
				return false;
			}
			if (actual==null){
				actual=new LinkedList();
			}
			if (coll.size()!=actual.size()){
				return false;
			}else{
				//pr?fe, ob die Namen passen
				Iterator iter=coll.iterator();
				while (iter.hasNext()){
					if (!actual.contains(iter.next())){
						return false;
					}
				}
			}
		}
		
		//gibt nur true zurueck, wenn in allen loops die gleiche nicht leere Anzahl von Eintraegen vorhanden ist und die Eintraege auch 
		//noch im Namen uebereinstimmen
		return true;
	}


	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#setNumberOfLoops(int)
	 */
	public void setNumberOfLoops(int numberofloops) {
		if (numberofloops==0){
			numberofloops=1;
		}

		if (features==null){
			initFeatures();
		}

		if (features.size()<numberofloops){
			while (features.size()!=numberofloops){
				features.add(new LinkedList());
			}
		}else if (features.size()>numberofloops){
			while (features.size()!=numberofloops){
				features.remove(paramcollections.size()-1);
			}
		}

		super.setNumberOfLoops(numberofloops);
	}

}
/*
$Log: SingleBaseAttributeEditor.java,v $
Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:14  hakenjos
Initial version!

*/
