/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.BorderLayout;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import javax.swing.JPanel;
import javax.swing.JTextField;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * An editor for output parameter
 * @author Daniel Hakenjos
 * @version $Id: OutputEditor.java,v 1.3 2006/04/11 14:10:13 euler Exp $
 */
public class OutputEditor	extends ParameterEditor {

	private JTextField field;

	private String paramobject;

	public OutputEditor(MiningMartApplication app, Step step, OpParam opParam){
		super(app,step,opParam);

		editorComponent=new JPanel(new BorderLayout());
		field=new JTextField();
		((JPanel) editorComponent).add(field,BorderLayout.CENTER);

		init();
		setEditable();
	}
	
	public void init(){
		try{
			field.setText("");
			Collection coll=getParameterCollection();//step.getParameter(opParam,0);
			if ((coll!=null)&&(!coll.isEmpty())){
				Iterator iter=coll.iterator();
				if (iter.hasNext()){
					this.paramobject=(String) iter.next();
				}
				if (paramobject!=null){
					if (opParam.isBaseAttribParameter()){
						field.setText(paramobject);
					}else
					if (opParam.isConceptParameter()){
						field.setText(paramobject);
					}else
					if (opParam.isFeatureParameter()){
						field.setText(paramobject);
					}else
					if (opParam.isMcfParameter()){
						field.setText(paramobject);
					}else
					if (opParam.isRelationParameter()){
						field.setText(paramobject);
					}else
					if (opParam.isValueParameter()){
						field.setText(paramobject);
					}
				}
			}else{
				field.setText("");
				setParameterCollection(new LinkedList());
			}
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
		
	}

	/**
	 * @see javax.swing.CellEditor#stopCellEditing()
	 */
	public boolean stopCellEditing() {
		Collection coll=getParameterCollection();
		boolean changed=true;
		if (coll!=null){
			Iterator iter=coll.iterator();
			String name=null;
			if (iter.hasNext()){
				name=(String) iter.next();
				if (name.equals(field.getText())){
					changed=false;
				}else{
					changed=true;
				}
			}
		}else{
			changed=true;
		}

		if (changed){
			LinkedList list=new LinkedList();
			list.add(field.getText());
			setParameterCollection(list);
			this.fireStateChanged();
		}

		return super.stopCellEditing();
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#existsOutput()
	 */
	public boolean existsOutput() {
		try {
			if (opParam.isConceptParameter()){
				Collection coll;
				Collection actual;
				for(int loop=1;loop<=numberofloops;loop++){
					coll=(Collection) this.oldparamcollections.get(loop-1);
					actual=(Collection) this.paramcollections.get(loop-1);
					if (coll==null){
						return false;
					}
					if (coll.isEmpty()){
						return false;
					}
					if (actual==null){
						actual=new LinkedList();
					}
					if (coll.size()!=actual.size()){
						return false;
					}
					
				}
				return true;
			}
		} catch (M4Exception e) {
			M4Interface.print.doPrint(Print.ERROR,e.getMessage(),e);
		}
		
		//die Ueberpruefung ist hier zu kompliziert, deshlab lieber gleich neu anlegen
		return false;
	}
	
	

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#setEditable()
	 */
	public void setEditable() {
		super.setEditable();
		field.setEditable(editable);
	}

}
/*
$Log: OutputEditor.java,v $
Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:14  hakenjos
Initial version!

*/
